/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.modpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.loc.ImageUdaterButton;
import org.tlauncher.tlauncher.ui.modpack.TemlateModpackFrame;
import org.tlauncher.util.OS;
import org.tlauncher.util.U;

public class BigPictureObserver
extends TemlateModpackFrame {
    private Color backgroundPanel = new Color(188, 188, 188);
    private static final int heightPanel = 586;
    private static final int width = 1050;
    int currentPicture;
    final JLabel picture = new JLabel();
    private Integer[] array;

    public BigPictureObserver(JFrame parent, String title, final Integer[] array, int i) {
        super(parent, title, new Dimension(1050, 586), OS.is(OS.LINUX));
        this.currentPicture = i;
        this.array = array;
        JLayeredPane layeredPane = new JLayeredPane();
        Button previousPicture = new Button("big-picture-previous-arrow.png", "previous-arrow-under.png");
        Button nextPicture = new Button("big-picture-next-arrow.png", "next-arrow-under.png");
        previousPicture.setPreferredSize(new Dimension(46, 155));
        nextPicture.setPreferredSize(new Dimension(46, 155));
        layeredPane.setBackground(this.backgroundPanel);
        this.picture.setBorder(BorderFactory.createLineBorder(Color.white, 5));
        final JLabel close = new JLabel(ImageCache.getNativeIcon((String)"picture-exit.png"));
        close.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                close.setIcon(ImageCache.getNativeIcon((String)"picture-exit-on.png"));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                close.setIcon(ImageCache.getNativeIcon((String)"picture-exit.png"));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    BigPictureObserver.this.setVisible(false);
                }
            }
        });
        layeredPane.add((Component)previousPicture, 1);
        layeredPane.add((Component)nextPicture, 1);
        layeredPane.add((Component)this.picture, 1);
        layeredPane.add((Component)close, 0);
        layeredPane.setSize(new Dimension(1050, 586));
        previousPicture.setBounds(10, 266, 19, 33);
        nextPicture.setBounds(1021, 266, 19, 33);
        this.putOnPanel(close);
        this.add(layeredPane);
        nextPicture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BigPictureObserver.this.currentPicture < array.length - 1) {
                    ++BigPictureObserver.this.currentPicture;
                    BigPictureObserver.this.putOnPanel(close);
                }
            }
        });
        previousPicture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BigPictureObserver.this.currentPicture > 0) {
                    --BigPictureObserver.this.currentPicture;
                    BigPictureObserver.this.putOnPanel(close);
                }
            }
        });
    }

    private void putOnPanel(JLabel close) {
        CompletableFuture.runAsync(() -> {
            try {
                this.picture.setIcon(new ImageIcon(ImageCache.loadImage((URL)new URL(ModpackUtil.getPictureURL(this.array[this.currentPicture], "_max_full")))));
            }
            catch (Exception e) {
                U.log(e);
            }
        }).thenAccept(e -> {
            Dimension pictureSize = this.picture.getPreferredSize();
            this.picture.setBounds((1050 - pictureSize.width) / 2, (586 - pictureSize.height) / 2, pictureSize.width, pictureSize.height);
            close.setBounds((1050 - pictureSize.width) / 2 + pictureSize.width - 21, (586 - pictureSize.height) / 2 - 21, 42, 42);
        });
    }

    private class Button
    extends ImageUdaterButton {
        public Button(final String s, final String s1) {
            super(s);
            this.setOpaque(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    Button.super.setImage(Button.loadImage(s1));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Button.super.setImage(Button.loadImage(s));
                }
            });
        }

        @Override
        public void paintComponent(Graphics g) {
            this.paintPicture(g, this, this.getBounds());
        }
    }
}

