/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.progress;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SpringLayout;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.ui.PreloaderProgressUI;

public class ProgressFrame
extends JFrame {
    private static final int WIDTH = 240;
    private static final int HEIGHT = 99;
    private Font font = new Font("Verdana", 0, 10);
    private String version_info;
    private JProgressBar progressBar;
    public final Color VERSION_BACKGROUND = new Color(40, 134, 187);

    @Inject
    public ProgressFrame(@Assisted(value="info") String info) {
        this.getContentPane().setForeground(Color.LIGHT_GRAY);
        this.setTitle("TLauncher");
        this.setSize(240, 99);
        this.setLocationRelativeTo(null);
        this.setUndecorated(true);
        this.setResizable(false);
        this.setBackground(Color.LIGHT_GRAY);
        this.setDefaultCloseOperation(3);
        this.version_info = info;
        SpringLayout springLayout = new SpringLayout();
        this.getContentPane().setLayout(springLayout);
        this.getContentPane().setPreferredSize(new Dimension(240, 99));
        JLabel version = new JLabel(this.version_info);
        version.setHorizontalAlignment(0);
        version.setForeground(Color.WHITE);
        version.setFont(this.font);
        version.setOpaque(true);
        version.setBackground(this.VERSION_BACKGROUND);
        springLayout.putConstraint("North", (Component)version, 0, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)version, -58, "East", (Component)this.getContentPane());
        springLayout.putConstraint("South", (Component)version, 16, "North", (Component)this.getContentPane());
        springLayout.putConstraint("East", (Component)version, 0, "East", (Component)this.getContentPane());
        this.getContentPane().add(version);
        JLabel backgroundImage = new JLabel();
        backgroundImage.setIcon(ImageCache.getNativeIcon((String)"tlauncher.png"));
        springLayout.putConstraint("North", (Component)backgroundImage, 0, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)backgroundImage, 0, "West", (Component)this.getContentPane());
        springLayout.putConstraint("South", (Component)backgroundImage, 75, "North", (Component)this.getContentPane());
        springLayout.putConstraint("East", (Component)backgroundImage, 244, "West", (Component)this.getContentPane());
        this.getContentPane().add(backgroundImage);
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setBorder(BorderFactory.createEmptyBorder());
        this.progressBar.setUI(new PreloaderProgressUI(ImageCache.getBufferedImage((String)"bottom-bar.png"), ImageCache.getBufferedImage((String)"up-progress-bar.png")));
        springLayout.putConstraint("North", (Component)this.progressBar, 0, "South", (Component)backgroundImage);
        springLayout.putConstraint("West", (Component)this.progressBar, 0, "West", (Component)this.getContentPane());
        springLayout.putConstraint("South", (Component)this.progressBar, 0, "South", (Component)this.getContentPane());
        springLayout.putConstraint("East", (Component)this.progressBar, 4, "East", (Component)this.getContentPane());
        this.getContentPane().add(this.progressBar);
        this.pack();
        this.setVisible(true);
    }
}

