/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import com.google.inject.Injector;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import net.minecraft.launcher.versions.CompleteVersion;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.share.Category;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.controller.modpack.FullGameEntityController;
import org.tlauncher.tlauncher.managers.ModpackManager;
import org.tlauncher.tlauncher.modpack.ModpackUtil;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.button.StatusStarButton;
import org.tlauncher.tlauncher.ui.images.ImageCache;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityPanel;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.UpdaterButton;
import org.tlauncher.tlauncher.ui.loc.UpdaterFullButton;
import org.tlauncher.tlauncher.ui.loc.modpack.GameRightButton;
import org.tlauncher.tlauncher.ui.loc.modpack.ModpackActButton;
import org.tlauncher.tlauncher.ui.loc.modpack.ModpackTableVersionButton;
import org.tlauncher.tlauncher.ui.loc.modpack.UpInstallButton;
import org.tlauncher.tlauncher.ui.login.LoginForm;
import org.tlauncher.tlauncher.ui.menu.ModpackCategoryPopupMenu;
import org.tlauncher.tlauncher.ui.modpack.GroupPanel;
import org.tlauncher.tlauncher.ui.modpack.OldModpackFrame;
import org.tlauncher.tlauncher.ui.modpack.PicturePanel;
import org.tlauncher.tlauncher.ui.modpack.filter.BaseModpackFilter;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.scenes.PseudoScene;
import org.tlauncher.tlauncher.ui.server.BackPanel;
import org.tlauncher.tlauncher.ui.swing.GameRadioButton;
import org.tlauncher.tlauncher.ui.swing.HtmlTextPane;
import org.tlauncher.tlauncher.ui.swing.ScrollPane;
import org.tlauncher.tlauncher.ui.swing.TextWrapperLabel;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.tlauncher.ui.swing.extended.ExtendedPanel;
import org.tlauncher.tlauncher.ui.swing.renderer.JTableButtonRenderer;
import org.tlauncher.tlauncher.ui.ui.ModpackScrollBarUI;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.OS;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.async.AsyncThread;
import org.tlauncher.util.swing.FontTL;

public class CompleteSubEntityScene
extends PseudoScene {
    protected final ExtendedPanel panel = new ExtendedPanel(new GridLayout(1, 1, 0, 0));
    protected final String REVIEW_S = "REVIEW";
    protected final String VERSION_S = "VERSIONS";
    protected final String PICTURES_S = "PICTURES";
    protected final ModpackManager manager = (ModpackManager)TLauncher.getInjector().getInstance(ModpackManager.class);
    protected FullGameEntity fullGameEntity;
    public static final int BUTTON_PANEL_SUB_VIEW = 130;

    public CompleteSubEntityScene(MainPane main) {
        super(main);
        this.panel.setSize(ModpackScene.SIZE);
        this.panel.setOpaque(true);
        this.add((Component)this.panel);
    }

    @Override
    public void onResize() {
        super.onResize();
        this.panel.setLocation(this.getWidth() / 2 - this.panel.getWidth() / 2, (this.getHeight() - LoginForm.LOGIN_SIZE.height) / 2 - this.panel.getHeight() / 2);
    }

    public void showFullGameEntity(GameEntityDTO gameEntityDTO, final GameType type) {
        this.clean(type);
        U.debug("open " + gameEntityDTO.getName() + " " + U.memoryStatus());
        BackPanel backPanel = new BackPanel("", new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    CompleteSubEntityScene.this.getMainPane().setScene(CompleteSubEntityScene.this.getMainPane().modpackScene);
                    CompleteSubEntityScene.this.clean(type);
                }
            }
        }, ImageCache.getIcon((String)"back-arrow.png"));
        this.fullGameEntity = new FullGameEntity(gameEntityDTO, backPanel, type);
        this.panel.add((Component)this.fullGameEntity);
        if (this.getMainPane().getScene() != this) {
            this.getMainPane().setScene(this);
        } else {
            this.panel.revalidate();
            this.panel.repaint();
        }
    }

    protected void clean(GameType type) {
        if (this.fullGameEntity != null) {
            this.panel.remove(this.fullGameEntity);
            this.manager.removeGameListener(type, this.fullGameEntity);
            this.fullGameEntity = null;
        }
    }

    public void showModpackElement(GameEntityDTO completeGameEntity, final GameType type) {
        this.clean(type);
        BackPanel backPanel = new BackPanel("", new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    CompleteSubEntityScene.this.getMainPane().setScene(CompleteSubEntityScene.this.getMainPane().modpackEnitityScene);
                    CompleteSubEntityScene.this.clean(type);
                }
            }
        }, ImageCache.getIcon((String)"back-arrow.png"));
        this.fullGameEntity = new FullGameEntity(completeGameEntity, backPanel, type);
        this.panel.add((Component)this.fullGameEntity);
        this.revalidate();
        this.repaint();
        this.getMainPane().setScene(this);
    }

    class CompleteDescriptionGamePanel
    extends DescriptionGamePanel {
        public static final int SHADOW_PANEL = 223;

        public CompleteDescriptionGamePanel(GameEntityDTO entity, GameType type) {
            super(entity, type);
        }

        @Override
        protected void paintComponent(Graphics g0) {
            super.paintComponent(g0);
            Rectangle rec = this.getVisibleRect();
            int i = 223;
            Graphics2D g2 = (Graphics2D)g0;
            for (int y = rec.y; y < rec.height + rec.y; ++y) {
                g2.setColor(new Color(i, i, i));
                if (i != 255) {
                    ++i;
                }
                g2.drawLine(rec.x, y, rec.x + rec.width, y);
            }
        }
    }

    protected class FullGameEntity
    extends GameEntityPanel {
        private final Color UP_BACKGROUND = new Color(60, 170, 232);
        private UpInstallButton installButton;
        private GameEntityDTO entity;
        private GameType type;
        private DescriptionGamePanel viewEntity;
        private Injector injector;
        private GroupPanel centerButtons;
        private JPanel centerView;
        private FullGameEntityController controller = new FullGameEntityController();

        public GroupPanel getCenterButtons() {
            return this.centerButtons;
        }

        public JPanel getCenterView() {
            return this.centerView;
        }

        private FullGameEntity(final GameEntityDTO entity, BackPanel backPanel, final GameType type) {
            this.entity = entity;
            this.type = type;
            this.injector = TLauncher.getInjector();
            SpringLayout spring = new SpringLayout();
            this.setLayout(spring);
            UpdaterFullButton officialSite = new UpdaterFullButton(this.UP_BACKGROUND, ColorUtil.BLUE_MODPACK_BUTTON_UP, "modpack.complete.site.button", "official-site.png");
            if (entity.getOfficialSite() == null) {
                officialSite.setVisible(false);
            }
            officialSite.setIconTextGap(15);
            ButtonGroup group = new ButtonGroup();
            GameRadioButton reviewButton = new GameRadioButton("modpack.complete.review.button");
            GameRadioButton picturesButton = new GameRadioButton("modpack.complete.picture.button");
            reviewButton.setSelected(true);
            reviewButton.setActionCommand("REVIEW");
            picturesButton.setActionCommand("PICTURES");
            group.add(reviewButton);
            group.add(picturesButton);
            Dimension dim = new Dimension(130, 52);
            reviewButton.setPreferredSize(dim);
            picturesButton.setPreferredSize(dim);
            GameRadioButton versionsButton = new GameRadioButton("modpack.complete.versions.button");
            versionsButton.setActionCommand("VERSIONS");
            group.add(versionsButton);
            versionsButton.setPreferredSize(dim);
            final Color backgroundOldButtonColor = new Color(213, 213, 213);
            final UpdaterButton oldButton = new UpdaterButton(backgroundOldButtonColor, "modpack.complete.old.button");
            oldButton.setForeground(Color.WHITE);
            oldButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    oldButton.setBackground(new Color(160, 160, 160));
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    oldButton.setBackground(backgroundOldButtonColor);
                }
            });
            oldButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OldModpackFrame old = new OldModpackFrame((JFrame)TLauncher.getInstance().getFrame(), entity, type);
                    old.setVisible(true);
                }
            });
            oldButton.setPreferredSize(dim);
            final JLabel originalEnDescription = new JLabel((Icon)ImageCache.getIcon((String)"modpack-original-transation.png"));
            originalEnDescription.setBorder(BorderFactory.createEmptyBorder());
            if (TLauncher.getInstance().getConfiguration().getLocale().getLanguage().equals("en")) {
                originalEnDescription.setVisible(false);
            }
            this.installButton = new UpInstallButton(entity, type, CompleteSubEntityScene.this.getMainPane().modpackScene.localmodpacks);
            this.installButton.setBorder(BorderFactory.createEmptyBorder(0, 19, 0, 0));
            this.installButton.setIconTextGap(18);
            ExtendedPanel reviewPanel = new ExtendedPanel();
            reviewPanel.setLayout(new FlowLayout(0, 0, 0));
            reviewPanel.setOpaque(true);
            reviewPanel.setBackground(ColorUtil.COLOR_246);
            ExtendedPanel versionsPanel = new ExtendedPanel();
            versionsPanel.setLayout(new BorderLayout());
            this.viewEntity = new CompleteDescriptionGamePanel(entity, type);
            final VersionModel model = new VersionModel(entity.getVersions());
            backPanel.addBackListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        CompleteSubEntityScene.this.manager.removeGameListener(type, model);
                    }
                }
            });
            CompleteSubEntityScene.this.manager.addGameListener(type, model);
            ModpackTable table = new ModpackTable(model);
            table.setBackground(Color.WHITE);
            ScrollPane c = ModpackScene.createScrollWrapper(table);
            versionsPanel.add((Component)c, "Center");
            SpringLayout upSpring = new SpringLayout();
            ExtendedPanel upButtons = new ExtendedPanel(upSpring);
            upButtons.setOpaque(true);
            upButtons.setBackground(this.UP_BACKGROUND);
            SpringLayout centerLayout = new SpringLayout();
            this.centerButtons = new GroupPanel(242);
            this.centerButtons.setLayout(centerLayout);
            this.centerButtons.setOpaque(true);
            SwingUtil.configHorizontalSpingLayout(centerLayout, reviewButton, this.centerButtons, 0);
            centerLayout.putConstraint("West", (Component)reviewButton, 66, "West", (Component)this.centerButtons);
            centerLayout.putConstraint("East", (Component)reviewButton, 196, "West", (Component)this.centerButtons);
            this.centerButtons.addInGroup(reviewButton);
            SwingUtil.configHorizontalSpingLayout(centerLayout, picturesButton, reviewButton, 130);
            this.centerButtons.addInGroup(picturesButton);
            SwingUtil.configHorizontalSpingLayout(centerLayout, versionsButton, picturesButton, 130);
            this.centerButtons.addInGroup(versionsButton);
            SwingUtil.configHorizontalSpingLayout(centerLayout, oldButton, this.centerButtons, 130);
            centerLayout.putConstraint("West", (Component)oldButton, -215, "East", (Component)this.centerButtons);
            centerLayout.putConstraint("East", (Component)oldButton, -66, "East", (Component)this.centerButtons);
            this.centerButtons.add((Component)oldButton);
            centerLayout.putConstraint("North", (Component)originalEnDescription, 12, "North", (Component)this.centerButtons);
            centerLayout.putConstraint("South", (Component)originalEnDescription, -12, "South", (Component)this.centerButtons);
            centerLayout.putConstraint("West", (Component)originalEnDescription, -45, "East", (Component)this.centerButtons);
            centerLayout.putConstraint("West", (Component)originalEnDescription, -45, "East", (Component)this.centerButtons);
            centerLayout.putConstraint("East", (Component)originalEnDescription, -20, "East", (Component)this.centerButtons);
            this.centerButtons.add((Component)originalEnDescription);
            this.centerView = new JPanel(new CardLayout(0, 0));
            this.centerView.setBackground(Color.WHITE);
            this.centerView.setOpaque(true);
            SwingUtil.configHorizontalSpingLayout(upSpring, backPanel, upButtons, 66);
            upSpring.putConstraint("West", (Component)backPanel, 0, "West", (Component)upButtons);
            upSpring.putConstraint("East", (Component)backPanel, 66, "West", (Component)upButtons);
            upButtons.add((Component)backPanel);
            SwingUtil.configHorizontalSpingLayout(upSpring, this.installButton, backPanel, 168);
            upButtons.add((Component)this.installButton);
            SwingUtil.configHorizontalSpingLayout(upSpring, officialSite, this.installButton, 0);
            upSpring.putConstraint("West", (Component)officialSite, 563, "East", (Component)this.installButton);
            upSpring.putConstraint("East", (Component)officialSite, 762, "East", (Component)this.installButton);
            upButtons.add((Component)officialSite);
            int gup = 20;
            final HtmlTextPane descriptionFull = HtmlTextPane.get(entity.getDescription());
            descriptionFull.setOpaque(true);
            descriptionFull.setBackground(ColorUtil.COLOR_246);
            final JScrollPane jScrollPane = new JScrollPane(descriptionFull, 20, 31);
            jScrollPane.getVerticalScrollBar().setUI(new ModpackScrollBarUI(){

                @Override
                public Dimension getPreferredSize(JComponent c) {
                    return new Dimension(13, super.getPreferredSize((JComponent)c).height);
                }
            });
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jScrollPane.getVerticalScrollBar().setValue(0);
                }
            });
            int height = 318;
            ExtendedPanel panelDescription = new ExtendedPanel(new FlowLayout(0, 0, 0));
            panelDescription.setPreferredSize(new Dimension(ModpackScene.SIZE.width, height));
            jScrollPane.setPreferredSize(new Dimension(ModpackScene.SIZE.width - gup * 2, height - 40));
            panelDescription.setBorder(BorderFactory.createEmptyBorder(20, gup, 20, gup));
            ((Container)panelDescription).add(jScrollPane);
            ((Container)reviewPanel).add(panelDescription);
            SwingUtil.changeFontFamily(this.installButton, FontTL.ROBOTO_BOLD, 14, Color.WHITE);
            SwingUtil.changeFontFamily(officialSite, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
            SwingUtil.changeFontFamily(reviewButton, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(versionsButton, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(picturesButton, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(oldButton, FontTL.ROBOTO_REGULAR, 14, Color.WHITE);
            this.centerView.setBackground(Color.WHITE);
            this.centerView.add((Component)reviewPanel, "REVIEW");
            this.centerView.add((Component)versionsPanel, "VERSIONS");
            PicturePanel picturePanel = new PicturePanel(entity.getPictures().toArray(new Integer[0]));
            this.centerView.add((Component)picturePanel, "PICTURES");
            spring.putConstraint("North", (Component)upButtons, 0, "North", (Component)this);
            spring.putConstraint("West", (Component)upButtons, 0, "West", (Component)this);
            spring.putConstraint("South", (Component)upButtons, 56, "North", (Component)this);
            spring.putConstraint("East", (Component)upButtons, 0, "East", (Component)this);
            this.add((Component)upButtons);
            spring.putConstraint("North", (Component)this.viewEntity, 0, "South", (Component)upButtons);
            spring.putConstraint("West", (Component)this.viewEntity, 0, "West", (Component)this);
            spring.putConstraint("South", (Component)this.viewEntity, 159, "South", (Component)upButtons);
            spring.putConstraint("East", (Component)this.viewEntity, 0, "East", (Component)this);
            this.add((Component)this.viewEntity);
            spring.putConstraint("North", (Component)this.centerButtons, 0, "South", (Component)this.viewEntity);
            spring.putConstraint("West", (Component)this.centerButtons, 0, "West", (Component)this);
            spring.putConstraint("South", (Component)this.centerButtons, 52, "South", (Component)this.viewEntity);
            spring.putConstraint("East", (Component)this.centerButtons, 0, "East", (Component)this);
            this.add((Component)this.centerButtons);
            spring.putConstraint("North", (Component)this.centerView, 0, "South", (Component)this.centerButtons);
            spring.putConstraint("West", (Component)this.centerView, 0, "West", (Component)this);
            spring.putConstraint("South", (Component)this.centerView, 321, "South", (Component)this.centerButtons);
            spring.putConstraint("East", (Component)this.centerView, 0, "East", (Component)this);
            this.add((Component)this.centerView);
            ModpackManager modpackManager = (ModpackManager)this.injector.getInstance(ModpackManager.class);
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((CardLayout)FullGameEntity.this.centerView.getLayout()).show(FullGameEntity.this.centerView, e.getActionCommand());
                }
            };
            reviewButton.addActionListener(listener);
            versionsButton.addActionListener(listener);
            picturesButton.addActionListener(listener);
            officialSite.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (entity.getOfficialSite() == null) {
                        return;
                    }
                    OS.openLink(entity.getOfficialSite());
                }
            });
            modpackManager.addGameListener(type, this);
            backPanel.addBackListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        CompleteSubEntityScene.this.manager.removeGameListener(type, FullGameEntity.this);
                    }
                }
            });
            originalEnDescription.addMouseListener(new MouseAdapter(){
                private boolean active = true;

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        int currentValue = jScrollPane.getVerticalScrollBar().getValue();
                        if (this.active) {
                            try {
                                if (entity.getEnDescription() == null) {
                                    FullGameEntity.this.controller.getEnDescription(entity);
                                }
                                this.active = false;
                                descriptionFull.setText(entity.getEnDescription());
                            }
                            catch (IOException e) {
                                Alert.showError("", Localizable.get("modpack.remote.not.found", Localizable.get("modpack.try.later")), null);
                            }
                        } else {
                            descriptionFull.setText(entity.getDescription());
                            this.active = true;
                        }
                        SwingUtilities.invokeLater(() -> jScrollPane.getVerticalScrollBar().setValue(currentValue));
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    originalEnDescription.setIcon((Icon)ImageCache.getIcon((String)"modpack-original-transation-up.png"));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    originalEnDescription.setIcon((Icon)ImageCache.getIcon((String)"modpack-original-transation.png"));
                }
            });
        }

        @Override
        public void processingStarted(GameEntityDTO e, VersionDTO version) {
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
            this.installButton.installEntity(e, type);
        }

        @Override
        public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
        }

        @Override
        public void populateStatus(GameEntityDTO entity, GameType type, boolean state) {
            if (entity.getId().equals(this.entity.getId())) {
                this.viewEntity.getStatusStarButton().setStatus(state);
            }
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
            this.installButton.removeEntity(e);
        }

        class VersionModel
        extends BaseSubtypeModel<VersionModelElement> {
            VersionModel(List<? extends VersionDTO> list) {
                ModpackComboBox modpackComboBox = TLauncher.getInstance().getFrame().mp.modpackScene.localmodpacks;
                BaseModpackFilter<VersionDTO> filter = BaseModpackFilter.getBaseModpackStandardFilters(FullGameEntity.this.entity, FullGameEntity.this.type, modpackComboBox);
                for (VersionDTO versionDTO : list) {
                    ModpackTableVersionButton button = new ModpackTableVersionButton(FullGameEntity.this.entity, FullGameEntity.this.type, modpackComboBox, versionDTO, filter);
                    this.list.add(new VersionModelElement(button, FullGameEntity.this.entity, versionDTO));
                }
            }

            @Override
            public int getRowCount() {
                return this.list.size();
            }

            @Override
            public int getColumnCount() {
                return 5;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                VersionDTO v = ((VersionModelElement)this.list.get(rowIndex)).getVersion();
                switch (columnIndex) {
                    case 0: {
                        return this.format.format(new Date(v.getUpdateDate()));
                    }
                    case 1: {
                        return v.getName();
                    }
                    case 2: {
                        return v.getType();
                    }
                    case 4: {
                        return ((VersionModelElement)this.list.get(rowIndex)).getModpackActButton();
                    }
                    case 3: {
                        String version = ModpackUtil.getLatestGameVersion(v.getGameVersions());
                        return version == null ? Localizable.get("modpack.version.any") : version;
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 4) {
                    return BaseModelElement.class;
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public String getColumnName(int column) {
                String line = "";
                switch (column) {
                    case 0: {
                        line = Localizable.get("version.manager.editor.field.time");
                        return line.substring(0, line.length() - 1);
                    }
                    case 1: {
                        return Localizable.get("version.release");
                    }
                    case 2: {
                        line = Localizable.get("version.manager.editor.field.type");
                        return line.substring(0, line.length() - 1);
                    }
                    case 4: {
                        return Localizable.get("modpack.table.pack.element.operation");
                    }
                    case 3: {
                        return Localizable.get("modpack.table.pack.element.version");
                    }
                }
                return "";
            }

            @Override
            public void installEntity(GameEntityDTO e, GameType type) {
                int index = this.findByVersion(e, e.getVersion());
                if (index != -1) {
                    ((VersionModelElement)this.list.get(index)).getModpackActButton().setTypeButton("REMOVE");
                    this.fireTableCellUpdated(index, 4);
                }
            }

            @Override
            public void removeEntity(GameEntityDTO e) {
                int index = this.findByVersion(e, e.getVersion());
                if (index != -1) {
                    ((VersionModelElement)this.list.get(index)).getModpackActButton().setTypeButton("INSTALL");
                    this.fireTableCellUpdated(index, 4);
                }
            }

            @Override
            public void processingStarted(GameEntityDTO e, VersionDTO version) {
                if (e.getId().equals(FullGameEntity.this.entity.getId())) {
                    for (int i = 0; i < this.list.size(); ++i) {
                        if (!((VersionModelElement)this.list.get(i)).getVersion().getId().equals(version.getId())) continue;
                        ((VersionModelElement)this.list.get(i)).getModpackActButton().setTypeButton("PROCESSING");
                        this.fireTableCellUpdated(i, 4);
                        return;
                    }
                }
            }

            @Override
            public GameEntityDTO getRowObject(int rowIndex) {
                return null;
            }

            public int findByVersion(GameEntityDTO e, VersionDTO v) {
                if (e.getId().equals(FullGameEntity.this.entity.getId())) {
                    for (int i = 0; i < this.list.size(); ++i) {
                        VersionModelElement element = (VersionModelElement)this.list.get(i);
                        if (!element.getVersion().getId().equals(v.getId())) continue;
                        return i;
                    }
                }
                return -1;
            }

            @Override
            public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
                int index = this.findByVersion(e, v);
                if (index != -1) {
                    ((VersionModelElement)this.list.get(index)).getModpackActButton().reset();
                    this.fireTableCellUpdated(index, 4);
                }
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 4;
            }
        }
    }

    protected class ModpackTableRenderer
    extends DefaultTableCellRenderer {
        protected ModpackTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            DefaultTableCellRenderer cell = (DefaultTableCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setHorizontalAlignment(0);
            if (column == 1) {
                cell.setHorizontalAlignment(2);
            }
            SwingUtil.changeFontFamily(cell, FontTL.ROBOTO_REGULAR, 12, ColorUtil.COLOR_25);
            cell.setFocusable(false);
            if (hasFocus) {
                this.setBorder(BorderFactory.createEmptyBorder());
            }
            return cell;
        }
    }

    protected class ModpackTable
    extends JTable {
        protected void init() {
            this.setRowHeight(58);
            this.getColumnModel().setColumnSelectionAllowed(false);
            this.setShowVerticalLines(false);
            this.setCellSelectionEnabled(false);
            this.setGridColor(ColorUtil.COLOR_244);
            JTableHeader header = this.getTableHeader();
            header.setPreferredSize(new Dimension(header.getPreferredSize().width - 20, 48));
            header.setDefaultRenderer(new TableCellRenderer(){
                DefaultTableCellRenderer cellRenderer = new DefaultTableCellRenderer();

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    DefaultTableCellRenderer comp = (DefaultTableCellRenderer)this.cellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    comp.setBorder(BorderFactory.createEmptyBorder());
                    comp.setBackground(new Color(63, 186, 255));
                    comp.setHorizontalAlignment(0);
                    SwingUtil.changeFontFamily(comp, FontTL.ROBOTO_REGULAR, 12, Color.WHITE);
                    return comp;
                }
            });
            ModpackTableRenderer centerRenderer = new ModpackTableRenderer();
            for (int i = 0; i < this.getModel().getColumnCount() - 1; ++i) {
                this.getColumnModel().getColumn(i).setCellRenderer(centerRenderer);
            }
            this.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.getTableHeader().setReorderingAllowed(false);
            this.setDefaultEditor(BaseModelElement.class, new JTableButtonRenderer());
            this.setDefaultRenderer(BaseModelElement.class, new JTableButtonRenderer());
        }

        public ModpackTable(AbstractTableModel model) {
            super(model);
            this.init();
        }
    }

    protected abstract class GameEntityTableModel
    extends AbstractTableModel
    implements GameEntityListener {
        protected GameEntityTableModel() {
        }

        @Override
        public void activationStarted(GameEntityDTO e) {
        }

        @Override
        public void activation(GameEntityDTO e) {
        }

        @Override
        public void activationError(GameEntityDTO e, Throwable t) {
        }

        @Override
        public void processingStarted(GameEntityDTO e, VersionDTO version) {
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
        }

        @Override
        public void installEntity(CompleteVersion e) {
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
        }

        @Override
        public void removeCompleteVersion(CompleteVersion e) {
        }

        @Override
        public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
        }

        @Override
        public void populateStatus(GameEntityDTO status, GameType type, boolean state) {
        }

        @Override
        public void updateVersion(CompleteVersion v, CompleteVersion newVersion) {
        }
    }

    private class VersionModelElement
    extends BaseModelElement {
        private VersionDTO version;

        public VersionModelElement(ModpackActButton modpackActButton, GameEntityDTO entity, VersionDTO version) {
            super(modpackActButton, entity);
            this.version = version;
        }

        public VersionDTO getVersion() {
            return this.version;
        }

        public void setVersion(VersionDTO version) {
            this.version = version;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VersionModelElement)) {
                return false;
            }
            VersionModelElement other = (VersionModelElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VersionDTO this$version = this.getVersion();
            VersionDTO other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !((Object)this$version).equals(other$version));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof VersionModelElement;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VersionDTO $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "CompleteSubEntityScene.VersionModelElement(version=" + this.getVersion() + ")";
        }
    }

    protected static class BaseModelElement {
        private ModpackActButton modpackActButton;
        private GameEntityDTO entity;

        public BaseModelElement(ModpackActButton modpackActButton, GameEntityDTO entity) {
            this.modpackActButton = modpackActButton;
            this.entity = entity;
        }

        public ModpackActButton getModpackActButton() {
            return this.modpackActButton;
        }

        public GameEntityDTO getEntity() {
            return this.entity;
        }

        public void setModpackActButton(ModpackActButton modpackActButton) {
            this.modpackActButton = modpackActButton;
        }

        public void setEntity(GameEntityDTO entity) {
            this.entity = entity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BaseModelElement)) {
                return false;
            }
            BaseModelElement other = (BaseModelElement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ModpackActButton this$modpackActButton = this.getModpackActButton();
            ModpackActButton other$modpackActButton = other.getModpackActButton();
            if (this$modpackActButton == null ? other$modpackActButton != null : !this$modpackActButton.equals(other$modpackActButton)) {
                return false;
            }
            GameEntityDTO this$entity = this.getEntity();
            GameEntityDTO other$entity = other.getEntity();
            return !(this$entity == null ? other$entity != null : !((Object)this$entity).equals(other$entity));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BaseModelElement;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ModpackActButton $modpackActButton = this.getModpackActButton();
            result = result * 59 + ($modpackActButton == null ? 43 : $modpackActButton.hashCode());
            GameEntityDTO $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : ((Object)$entity).hashCode());
            return result;
        }

        public String toString() {
            return "CompleteSubEntityScene.BaseModelElement(modpackActButton=" + this.getModpackActButton() + ", entity=" + this.getEntity() + ")";
        }
    }

    private abstract class BaseSubtypeModel<T extends BaseModelElement>
    extends GameEntityTableModel {
        protected List<T> list = new ArrayList<T>();
        protected final SimpleDateFormat format = new SimpleDateFormat("dd/MM/YYYY", Localizable.get().getSelected());

        private BaseSubtypeModel() {
        }

        public abstract GameEntityDTO getRowObject(int var1);

        public int find(GameEntityDTO entity) {
            for (int i = 0; i < this.list.size(); ++i) {
                if (!entity.getId().equals(((BaseModelElement)this.list.get(i)).getEntity().getId())) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
            int index = this.find(e);
            if (index != -1) {
                ((BaseModelElement)this.list.get(index)).getModpackActButton().reset();
                this.fireTableCellUpdated(index, 4);
            }
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
            int index = this.find(e);
            if (index != -1) {
                ((BaseModelElement)this.list.get(index)).getModpackActButton().setTypeButton("REMOVE");
                this.fireTableCellUpdated(index, 4);
            }
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
            int index = this.find(e);
            if (index != -1) {
                ((BaseModelElement)this.list.get(index)).getModpackActButton().setTypeButton("INSTALL");
                this.fireTableCellUpdated(index, 4);
            }
        }
    }

    public static class DescriptionGamePanel
    extends JPanel {
        protected StatusStarButton statusStarButton;
        protected SpringLayout descriptionLayout;
        protected JLabel name;
        protected JTextArea description;
        protected JLabel downloadLabel;
        protected JLabel updateLabel;
        protected JLabel gameVersion;
        protected ImagePanel imagePanel;
        private int gupPair = 30;
        private int gup = 5;
        private SimpleDateFormat format = new SimpleDateFormat("dd MMMM YYYY", Localizable.get().getSelected());

        public StatusStarButton getStatusStarButton() {
            return this.statusStarButton;
        }

        public DescriptionGamePanel(GameEntityDTO entity, GameType type) {
            this.descriptionLayout = new SpringLayout();
            this.setLayout(this.descriptionLayout);
            this.statusStarButton = new StatusStarButton(entity, type);
            this.imagePanel = new ImagePanel(entity);
            VersionDTO versionDTO = entity.getVersions().get(0);
            ExtendedPanel descriptionEntityPanel = new ExtendedPanel();
            this.name = new JLabel(entity.getName());
            LocalizableLabel authorLabel = new LocalizableLabel("modpack.complete.author");
            JLabel authorValue = new JLabel(entity.getAuthor());
            this.downloadLabel = new LocalizableLabel("modpack.description.download");
            JLabel downloadValue = new JLabel(this.getStringDownloadingCount(entity.getDownloadALL()));
            this.updateLabel = new LocalizableLabel("modpack.description.date");
            JLabel updateValue = new JLabel(this.format.format(new Date(versionDTO.getUpdateDate())));
            this.gameVersion = new JLabel();
            LocalizableLabel gameVersionLabel = new LocalizableLabel("modpack.creation.version.game");
            if (versionDTO.getGameVersions() == null || versionDTO.getGameVersions().isEmpty()) {
                this.gameVersion.setVisible(false);
                gameVersionLabel.setVisible(false);
            } else {
                HashSet<String> versions = new HashSet<String>();
                entity.getVersions().forEach(e -> versions.addAll(e.getGameVersions()));
                this.gameVersion.setText(ModpackUtil.getLatestGameVersion(versions));
            }
            this.description = new TextWrapperLabel(entity.getShortDescription());
            this.description.setVisible(false);
            authorValue.setHorizontalAlignment(2);
            downloadValue.setHorizontalAlignment(2);
            updateValue.setHorizontalAlignment(2);
            this.gameVersion.setHorizontalAlignment(2);
            SwingUtil.changeFontFamily(this.name, FontTL.ROBOTO_BOLD, 18);
            SwingUtil.changeFontFamily(authorLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_193);
            SwingUtil.changeFontFamily(this.downloadLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(gameVersionLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(this.updateLabel, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
            SwingUtil.changeFontFamily(authorValue, FontTL.ROBOTO_REGULAR, 14, ColorUtil.BLUE_MODPACK);
            SwingUtil.changeFontFamily(downloadValue, FontTL.ROBOTO_REGULAR, 14, ColorUtil.BLUE_MODPACK);
            SwingUtil.changeFontFamily(updateValue, FontTL.ROBOTO_REGULAR, 14, ColorUtil.BLUE_MODPACK);
            SwingUtil.changeFontFamily(this.gameVersion, FontTL.ROBOTO_REGULAR, 14, ColorUtil.BLUE_MODPACK);
            SwingUtil.changeFontFamily(this.description, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_64);
            SpringLayout descriptionSpring = new SpringLayout();
            descriptionEntityPanel.setLayout(descriptionSpring);
            this.descriptionLayout.putConstraint("West", (Component)this.imagePanel, 66, "West", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)this.imagePanel, 177, "West", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)this.imagePanel, 25, "North", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)this.imagePanel, -25, "South", (Component)this);
            this.add(this.imagePanel);
            this.descriptionLayout.putConstraint("West", (Component)descriptionEntityPanel, 13, "East", (Component)this.imagePanel);
            this.descriptionLayout.putConstraint("East", (Component)descriptionEntityPanel, 0, "East", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)descriptionEntityPanel, 25, "North", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)descriptionEntityPanel, -20, "South", (Component)this);
            this.add(descriptionEntityPanel);
            descriptionSpring.putConstraint("West", (Component)this.name, 0, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("East", (Component)this.name, 250, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)this.name, 0, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.name, 23, "North", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.name);
            descriptionSpring.putConstraint("West", (Component)authorLabel, 0, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("East", (Component)authorLabel, authorLabel.getPreferredSize().width, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)authorLabel, 23, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)authorLabel, 42, "North", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)authorLabel);
            descriptionSpring.putConstraint("West", (Component)authorValue, this.gup, "East", (Component)authorLabel);
            descriptionSpring.putConstraint("East", (Component)authorValue, 0, "East", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)authorValue, 23, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)authorValue, 42, "North", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)authorValue);
            descriptionSpring.putConstraint("West", (Component)this.description, 0, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("East", (Component)this.description, -100, "East", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)this.description, 46, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.description, 85, "North", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.description);
            descriptionSpring.putConstraint("West", (Component)this.downloadLabel, 0, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("East", (Component)this.downloadLabel, this.downloadLabel.getPreferredSize().width, "West", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("North", (Component)this.downloadLabel, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.downloadLabel, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.downloadLabel);
            descriptionSpring.putConstraint("West", (Component)downloadValue, this.gup, "East", (Component)this.downloadLabel);
            descriptionSpring.putConstraint("East", (Component)downloadValue, downloadValue.getPreferredSize().width + this.gup, "East", (Component)this.downloadLabel);
            descriptionSpring.putConstraint("North", (Component)downloadValue, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)downloadValue, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)downloadValue);
            descriptionSpring.putConstraint("West", (Component)this.updateLabel, this.gupPair, "East", (Component)downloadValue);
            descriptionSpring.putConstraint("East", (Component)this.updateLabel, this.gupPair + this.updateLabel.getPreferredSize().width, "East", (Component)downloadValue);
            descriptionSpring.putConstraint("North", (Component)this.updateLabel, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.updateLabel, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.updateLabel);
            descriptionSpring.putConstraint("West", (Component)updateValue, this.gup, "East", (Component)this.updateLabel);
            descriptionSpring.putConstraint("East", (Component)updateValue, updateValue.getPreferredSize().width + this.gup, "East", (Component)this.updateLabel);
            descriptionSpring.putConstraint("North", (Component)updateValue, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)updateValue, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)updateValue);
            descriptionSpring.putConstraint("West", (Component)gameVersionLabel, this.gupPair, "East", (Component)updateValue);
            descriptionSpring.putConstraint("East", (Component)gameVersionLabel, this.gupPair + gameVersionLabel.getPreferredSize().width, "East", (Component)updateValue);
            descriptionSpring.putConstraint("North", (Component)gameVersionLabel, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)gameVersionLabel, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)gameVersionLabel);
            descriptionSpring.putConstraint("West", (Component)this.gameVersion, this.gup, "East", (Component)gameVersionLabel);
            descriptionSpring.putConstraint("East", (Component)this.gameVersion, this.gameVersion.getPreferredSize().width + this.gup, "East", (Component)gameVersionLabel);
            descriptionSpring.putConstraint("North", (Component)this.gameVersion, 90, "North", (Component)descriptionEntityPanel);
            descriptionSpring.putConstraint("South", (Component)this.gameVersion, 0, "South", (Component)descriptionEntityPanel);
            descriptionEntityPanel.add((Component)this.gameVersion);
            ExtendedPanel pictureCategories = new ExtendedPanel();
            int count = 0;
            for (Category c : entity.getCategories()) {
                Icon icon = null;
                try {
                    icon = ImageCache.getNativeIcon((String)("category/" + c.toString() + ".png"));
                }
                catch (NullPointerException e2) {
                    U.log("don't find category " + (Object)((Object)c));
                    continue;
                }
                ++count;
                final JLabel label = new JLabel(icon);
                label.setHorizontalAlignment(0);
                label.setAlignmentY(0.5f);
                pictureCategories.add((Component)label);
                final ModpackCategoryPopupMenu popupMenu = new ModpackCategoryPopupMenu(c, label);
                label.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        popupMenu.show(label, e.getX() + 15, e.getY() + 15);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        popupMenu.setVisible(false);
                    }
                });
            }
            pictureCategories.setLayout(new GridLayout(1, count, 0, 10));
            this.descriptionLayout.putConstraint("West", (Component)pictureCategories, -200, "East", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)pictureCategories, -25 - (5 - count) * 35, "East", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)pictureCategories, 24, "North", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)pictureCategories, 50, "North", (Component)this);
            this.add(pictureCategories);
            this.descriptionLayout.putConstraint("West", (Component)this.statusStarButton, -38, "East", (Component)this);
            this.descriptionLayout.putConstraint("East", (Component)this.statusStarButton, -25, "East", (Component)this);
            this.descriptionLayout.putConstraint("North", (Component)this.statusStarButton, -35, "South", (Component)this);
            this.descriptionLayout.putConstraint("South", (Component)this.statusStarButton, -22, "South", (Component)this);
            this.add(this.statusStarButton);
        }

        private String getStringDownloadingCount(Integer i) {
            String res = "";
            if (i < 1000) {
                return i.toString();
            }
            res = i < 1000000 ? i / 1000 + " " + Localizable.get("modpack.thousand") : i / 1000000 + " " + Localizable.get("modpack.million");
            if (TLauncher.getInstance().getConfiguration().getLocale().getLanguage().equals("en")) {
                res = res.replace(" ", "");
            }
            return res;
        }
    }

    public static class ImagePanel
    extends JLayeredPane {
        private GameRightButton gameRightButton;
        private GameEntityDTO entity;
        private JLabel label;
        private static ConcurrentLinkedDeque<String> images = new ConcurrentLinkedDeque();
        private static final Object object = new Object();

        public ImagePanel(GameEntityDTO entity) {
            this.entity = entity;
            this.setOpaque(true);
            this.label = new JLabel(){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    this.initPicture(g);
                }
            };
            this.label.setOpaque(true);
            this.add((Component)this.label, 1);
            this.label.setBounds(0, 0, 111, 111);
        }

        public void addMoapckActButton(GameRightButton actButton) {
            this.gameRightButton = actButton;
            this.add((Component)actButton, 0);
            actButton.setBounds(10, 80, 90, 23);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initPicture(Graphics g) {
            block9: {
                if (this.entity.getPicture() != null) {
                    try {
                        BufferedImage image;
                        String picture = ModpackUtil.getPictureURL(this.entity.getPicture(), "_logo");
                        if (!ImageCache.imageInCache((String)picture)) {
                            Object object = ImagePanel.object;
                            synchronized (object) {
                                images.push(picture);
                            }
                            if (images.size() == 1) {
                                this.loadImages();
                            }
                            break block9;
                        }
                        if (ImageCache.loadImage((URL)new URL(picture), (boolean)false) != null && (image = ImageCache.loadImage((URL)new URL(picture), (boolean)false)) != null) {
                            g.drawImage(image, 0, 0, null);
                        }
                    }
                    catch (Exception e) {
                        U.log(e);
                    }
                }
            }
        }

        private void loadImages() {
            AsyncThread.execute(() -> {
                try {
                    Thread.sleep(200L);
                    ArrayList<String> list = new ArrayList<String>();
                    Iterator iterator = object;
                    synchronized (iterator) {
                        int size = images.size() > 5 ? 5 : images.size();
                        for (int i = 0; i < size; ++i) {
                            list.add(images.pop());
                        }
                        images.clear();
                    }
                    for (String image : list) {
                        if (images.size() > 5) {
                            return;
                        }
                        ImageCache.loadImage((URL)new URL(image), (boolean)false);
                    }
                    if (this.gameRightButton != null) {
                        this.gameRightButton.updateRow();
                    } else {
                        this.label.repaint();
                    }
                }
                catch (Exception e) {
                    U.log(e);
                }
            });
        }
    }
}

