/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.scenes;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.tlauncher.modpack.domain.client.GameEntityDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.share.GameType;
import org.tlauncher.modpack.domain.client.version.ModpackVersionDTO;
import org.tlauncher.modpack.domain.client.version.VersionDTO;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.ui.MainPane;
import org.tlauncher.tlauncher.ui.listener.mods.GameEntityListener;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.loc.LocalizableLabel;
import org.tlauncher.tlauncher.ui.loc.modpack.ModpackTableInstallButton;
import org.tlauncher.tlauncher.ui.modpack.GroupPanel;
import org.tlauncher.tlauncher.ui.scenes.CompleteSubEntityScene;
import org.tlauncher.tlauncher.ui.scenes.ModpackScene;
import org.tlauncher.tlauncher.ui.swing.GameRadioButton;
import org.tlauncher.tlauncher.ui.swing.ScrollPane;
import org.tlauncher.tlauncher.ui.swing.box.ModpackComboBox;
import org.tlauncher.util.ColorUtil;
import org.tlauncher.util.SwingUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.swing.FontTL;

public class ModpackEnitityScene
extends CompleteSubEntityScene {
    public ModpackEnitityScene(MainPane main) {
        super(main);
    }

    public void showModpackEntity(GameEntityDTO completeGameEntity) {
        this.showFullGameEntity(completeGameEntity, GameType.MODPACK);
        ModpackDTO modPack = (ModpackDTO)completeGameEntity;
        GameRadioButton modReview = new GameRadioButton("modpack.complete.review.mod");
        modReview.setActionCommand(GameType.MOD.toString());
        GameRadioButton resourceReview = new GameRadioButton("modpack.complete.review.resource");
        resourceReview.setActionCommand(GameType.RESOURCEPACK.toString());
        GameRadioButton mapReview = new GameRadioButton("modpack.complete.review.map");
        mapReview.setActionCommand(GameType.MAP.toString());
        SwingUtil.changeFontFamily(mapReview, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(modReview, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        SwingUtil.changeFontFamily(resourceReview, FontTL.ROBOTO_REGULAR, 14, ColorUtil.COLOR_25);
        GroupPanel centerButtons = this.fullGameEntity.getCenterButtons();
        SpringLayout centerLayout = (SpringLayout)centerButtons.getLayout();
        SwingUtil.configHorizontalSpingLayout(centerLayout, modReview, centerButtons, 130);
        centerLayout.putConstraint("West", (Component)modReview, 456, "West", (Component)centerButtons);
        centerLayout.putConstraint("East", (Component)modReview, 586, "West", (Component)centerButtons);
        centerButtons.addInGroup(modReview);
        SwingUtil.configHorizontalSpingLayout(centerLayout, resourceReview, modReview, 130);
        centerButtons.addInGroup(resourceReview);
        SwingUtil.configHorizontalSpingLayout(centerLayout, mapReview, resourceReview, 130);
        centerButtons.addInGroup(mapReview);
        ModpackVersionDTO version = (ModpackVersionDTO)modPack.getVersion();
        final JPanel centerView = this.fullGameEntity.getCenterView();
        this.addModpackTableElement(version, GameType.MOD, completeGameEntity);
        this.addModpackTableElement(version, GameType.RESOURCEPACK, completeGameEntity);
        this.addModpackTableElement(version, GameType.MAP, completeGameEntity);
        modReview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout)centerView.getLayout()).show(centerView, GameType.MOD.toString());
            }
        });
        resourceReview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout)centerView.getLayout()).show(centerView, GameType.RESOURCEPACK.toString());
            }
        });
        mapReview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CardLayout)centerView.getLayout()).show(centerView, GameType.MAP.toString());
            }
        });
        ((CardLayout)centerView.getLayout()).show(centerView, "REVIEW");
    }

    private void addModpackTableElement(ModpackVersionDTO versionDTO, GameType type, GameEntityDTO entity) {
        ScrollPane table = ModpackScene.createScrollWrapper(new GameEntityTable(versionDTO.getByType(type), entity, type));
        if (versionDTO.getByType(type).size() == 0) {
            JLayeredPane panel = new JLayeredPane();
            LocalizableLabel emptyLabel = new LocalizableLabel("modpack.table.empty." + type.toString());
            emptyLabel.setHorizontalAlignment(0);
            emptyLabel.setAlignmentX(0.0f);
            SwingUtil.changeFontFamily(emptyLabel, FontTL.ROBOTO_BOLD, 18, ColorUtil.COLOR_16);
            panel.add((Component)emptyLabel, 1);
            panel.add((Component)table, 0);
            emptyLabel.setBounds(0, 160, MainPane.SIZE.width, 22);
            table.setBounds(0, 0, MainPane.SIZE.width, 321);
            this.fullGameEntity.getCenterView().add((Component)panel, type.toString());
        } else {
            this.fullGameEntity.getCenterView().add((Component)table, type.toString());
        }
    }

    private abstract class BaseSubtypeModel<T extends CompleteSubEntityScene.BaseModelElement>
    extends CompleteSubEntityScene.GameEntityTableModel {
        protected List<T> list = new ArrayList<T>();

        private BaseSubtypeModel() {
        }

        public abstract GameEntityDTO getRowObject(int var1);

        public T find(GameEntityDTO entity) {
            for (CompleteSubEntityScene.BaseModelElement el : this.list) {
                if (!entity.getId().equals(el.getEntity().getId())) continue;
                return (T)el;
            }
            return null;
        }

        @Override
        public void processingStarted(GameEntityDTO e, VersionDTO version) {
            T baseModelElement = this.find(e);
            if (baseModelElement != null) {
                ((CompleteSubEntityScene.BaseModelElement)baseModelElement).getModpackActButton().setTypeButton("PROCESSING");
            }
        }

        @Override
        public void installError(GameEntityDTO e, VersionDTO v, Throwable t) {
            T baseModelElement = this.find(e);
            if (baseModelElement != null) {
                ((CompleteSubEntityScene.BaseModelElement)baseModelElement).getModpackActButton().reset();
            }
        }

        @Override
        public void installEntity(GameEntityDTO e, GameType type) {
            T baseModelElement = this.find(e);
            if (baseModelElement != null) {
                ((CompleteSubEntityScene.BaseModelElement)baseModelElement).getModpackActButton().setTypeButton("REMOVE");
            }
        }

        @Override
        public void removeEntity(GameEntityDTO e) {
            T baseModelElement = this.find(e);
            if (baseModelElement != null) {
                ((CompleteSubEntityScene.BaseModelElement)baseModelElement).getModpackActButton().setTypeButton("INSTALL");
            }
        }
    }

    private class GameEntityTable
    extends CompleteSubEntityScene.ModpackTable {
        GameEntityTable(List<? extends GameEntityDTO> list, final GameEntityDTO parent, final GameType type) {
            super(new RemoteEntityModel(list, type));
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (GameEntityTable.this.getSelectedRow() == -1) {
                        return;
                    }
                    int column = GameEntityTable.this.getSelectedColumn();
                    if (column != 5) {
                        GameEntityDTO gameEntity = ((BaseSubtypeModel)GameEntityTable.this.getModel()).getRowObject(GameEntityTable.this.getSelectedRow());
                        ModpackEnitityScene.this.manager.showInnerModpackElement(gameEntity, parent, type);
                    }
                    GameEntityTable.this.getSelectionModel().clearSelection();
                }
            });
            ModpackEnitityScene.this.manager.addGameListener(type, (GameEntityListener)((Object)this.getModel()));
        }
    }

    private class RemoteEntityModel
    extends BaseSubtypeModel<CompleteSubEntityScene.BaseModelElement> {
        private SimpleDateFormat format = new SimpleDateFormat("dd MMMM YYYY", Localizable.get().getSelected());

        RemoteEntityModel(List<? extends GameEntityDTO> list, GameType type) {
            ModpackComboBox modpackComboBox = TLauncher.getInstance().getFrame().mp.modpackScene.localmodpacks;
            for (GameEntityDTO gameEntityDTO : list) {
                GameEntityDTO remoteGameEntity = null;
                for (GameEntityDTO gameEntityDTO2 : ModpackEnitityScene.this.manager.getInfoMod().getByType(type)) {
                    if (!gameEntityDTO2.getId().equals(gameEntityDTO.getId())) continue;
                    remoteGameEntity = gameEntityDTO2;
                    break;
                }
                if (remoteGameEntity == null) {
                    U.log("[RemoteEntityModel]", "don't find entity" + gameEntityDTO);
                    continue;
                }
                ModpackTableInstallButton button = new ModpackTableInstallButton(remoteGameEntity, type, modpackComboBox);
                this.list.add(new CompleteSubEntityScene.BaseModelElement(button, gameEntityDTO));
            }
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.format.format(((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getVersion().getUpdateDate());
                }
                case 1: {
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getName();
                }
                case 2: {
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getAuthor();
                }
                case 3: {
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getVersion().getName();
                }
                case 4: {
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity().getVersion().getType();
                }
                case 5: {
                    ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getModpackActButton().initButton();
                    return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getModpackActButton();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            String line = "";
            switch (column) {
                case 0: {
                    line = Localizable.get("version.manager.editor.field.time");
                    return line.substring(0, line.length() - 1);
                }
                case 1: {
                    return Localizable.get("modpack.table.pack.element.name");
                }
                case 2: {
                    return Localizable.get("modpack.table.pack.element.author");
                }
                case 3: {
                    return Localizable.get("version.release");
                }
                case 4: {
                    line = Localizable.get("version.manager.editor.field.type");
                    return line.substring(0, line.length() - 1);
                }
                case 5: {
                    return Localizable.get("modpack.table.pack.element.operation");
                }
            }
            return "";
        }

        @Override
        public GameEntityDTO getRowObject(int rowIndex) {
            return ((CompleteSubEntityScene.BaseModelElement)this.list.get(rowIndex)).getEntity();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 5) {
                return CompleteSubEntityScene.BaseModelElement.class;
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 5;
        }
    }
}

