/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.tlauncher.ui.swing;

import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;

public class SimpleComboBoxModel<E>
extends DefaultComboBoxModel<E> {
    private static final long serialVersionUID = 5950434966721171811L;
    protected Vector<E> objects;
    protected Object selectedObject;

    public SimpleComboBoxModel() {
        this.objects = new Vector();
    }

    public SimpleComboBoxModel(E[] items) {
        this.objects = new Vector(items.length);
        int c = items.length;
        for (int i = 0; i < c; ++i) {
            this.objects.addElement(items[i]);
        }
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    public SimpleComboBoxModel(Vector<E> v) {
        this.objects = v;
        if (this.getSize() > 0) {
            this.selectedObject = this.getElementAt(0);
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.selectedObject != null && !this.selectedObject.equals(anObject) || this.selectedObject == null && anObject != null) {
            this.selectedObject = anObject;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedObject;
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    @Override
    public E getElementAt(int index) {
        if (index >= 0 && index < this.objects.size()) {
            return this.objects.elementAt(index);
        }
        return null;
    }

    @Override
    public int getIndexOf(Object anObject) {
        return this.objects.indexOf(anObject);
    }

    @Override
    public void addElement(E anObject) {
        this.objects.addElement(anObject);
        int size = this.objects.size();
        int index = this.objects.size() - 1;
        this.fireIntervalAdded(this, index, index);
        if (size == 1 && this.selectedObject == null && anObject != null) {
            this.setSelectedItem(anObject);
        }
    }

    public void addElements(Collection<E> list) {
        if (list.size() == 0) {
            return;
        }
        int size = list.size();
        int index0 = this.objects.size();
        int index1 = index0 + size - 1;
        this.objects.addAll(list);
        this.fireIntervalAdded(this, index0, index1);
        if (this.selectedObject == null) {
            for (E elem : list) {
                if (elem == null) continue;
                this.setSelectedItem(elem);
                break;
            }
        }
    }

    @Override
    public void insertElementAt(E anObject, int index) {
        this.objects.insertElementAt(anObject, index);
        this.fireIntervalAdded(this, index, index);
    }

    @Override
    public void removeElementAt(int index) {
        if (this.getElementAt(index) == this.selectedObject) {
            if (index == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
            } else {
                this.setSelectedItem(this.getElementAt(index - 1));
            }
        }
        this.objects.removeElementAt(index);
        this.fireIntervalRemoved(this, index, index);
    }

    @Override
    public void removeElement(Object anObject) {
        int index = this.objects.indexOf(anObject);
        if (index != -1) {
            this.removeElementAt(index);
        }
    }

    @Override
    public void removeAllElements() {
        int size = this.objects.size();
        if (size > 0) {
            int firstIndex = 0;
            int lastIndex = size - 1;
            this.objects.removeAllElements();
            this.selectedObject = null;
            this.fireIntervalRemoved(this, firstIndex, lastIndex);
        } else {
            this.selectedObject = null;
        }
    }
}

