/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.util.guice;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.regex.Pattern;
import joptsimple.OptionSet;
import net.minecraft.launcher.versions.CompleteVersion;
import net.minecraft.launcher.versions.json.DateTypeAdapter;
import net.minecraft.launcher.versions.json.LowerCaseEnumTypeAdapterFactory;
import net.minecraft.launcher.versions.json.PatternTypeAdapter;
import org.tlauncher.modpack.domain.client.MapDTO;
import org.tlauncher.modpack.domain.client.ModDTO;
import org.tlauncher.modpack.domain.client.ModpackDTO;
import org.tlauncher.modpack.domain.client.ResourcePackDTO;
import org.tlauncher.tlauncher.minecraft.launcher.MinecraftLauncher;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.AdditionalFileAssistance;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.AdditionalFileAssistanceFactory;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.LanguageAssistance;
import org.tlauncher.tlauncher.minecraft.launcher.assitent.SoundAssist;
import org.tlauncher.tlauncher.minecraft.launcher.server.InnerMinecraftServer;
import org.tlauncher.tlauncher.minecraft.launcher.server.InnerMinecraftServersImpl;
import org.tlauncher.tlauncher.rmo.TLauncher;
import org.tlauncher.tlauncher.site.play.SitePlay;
import org.tlauncher.tlauncher.ui.alert.Alert;
import org.tlauncher.tlauncher.ui.explorer.FileChooser;
import org.tlauncher.tlauncher.ui.explorer.FileExplorer;
import org.tlauncher.tlauncher.ui.explorer.FileWrapper;
import org.tlauncher.tlauncher.ui.loc.Localizable;
import org.tlauncher.tlauncher.ui.progress.ProgressFrame;
import org.tlauncher.util.DoubleRunningTimer;
import org.tlauncher.util.TlauncherUtil;
import org.tlauncher.util.U;
import org.tlauncher.util.gson.serializer.MapDTOTypeAdapter;
import org.tlauncher.util.gson.serializer.ModDTOTypeAdapter;
import org.tlauncher.util.gson.serializer.ModpackDTOTypeAdapter;
import org.tlauncher.util.gson.serializer.ResourcePackDTOTypeAdapter;
import org.tlauncher.util.guice.CustomBarFactory;
import org.tlauncher.util.guice.LanguageAssistFactory;
import org.tlauncher.util.guice.MinecraftLauncherFactory;
import org.tlauncher.util.guice.SitePlayFactory;
import org.tlauncher.util.guice.SoundAssistFactory;
import org.tlauncher.util.guice.TlauncherFactory;

public class GuiceModule
extends AbstractModule {
    private OptionSet set;
    private Injector injector;
    private boolean usedDefaultChooser = true;

    public Injector getInjector() {
        return this.injector;
    }

    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public GuiceModule(OptionSet set) {
        this.set = set;
        try {
            new FileExplorer();
        }
        catch (Throwable t) {
            this.usedDefaultChooser = false;
        }
    }

    protected void configure() {
        this.bind(Gson.class).annotatedWith((Annotation)Names.named((String)"GsonCompleteVersion")).toInstance((Object)this.createGsonCompleteVersion());
        this.bind(Gson.class).annotatedWith((Annotation)Names.named((String)"GsonAdditionalFile")).toInstance((Object)this.createAddittionalFileGson());
        this.bind(InnerMinecraftServer.class).to(InnerMinecraftServersImpl.class);
        Class c = FileExplorer.class;
        if (!this.usedDefaultChooser) {
            c = FileWrapper.class;
        }
        this.bind(FileChooser.class).to(c);
        this.install(new FactoryModuleBuilder().implement(MinecraftLauncher.class, MinecraftLauncher.class).build(MinecraftLauncherFactory.class));
        this.install(new FactoryModuleBuilder().implement(TLauncher.class, TLauncher.class).build(TlauncherFactory.class));
        this.install(new FactoryModuleBuilder().implement(ProgressFrame.class, ProgressFrame.class).build(CustomBarFactory.class));
        this.install(new FactoryModuleBuilder().implement(SitePlay.class, SitePlay.class).build(SitePlayFactory.class));
        this.install(new FactoryModuleBuilder().implement(SoundAssist.class, SoundAssist.class).build(SoundAssistFactory.class));
        this.install(new FactoryModuleBuilder().implement(AdditionalFileAssistance.class, AdditionalFileAssistance.class).build(AdditionalFileAssistanceFactory.class));
        this.install(new FactoryModuleBuilder().implement(LanguageAssistance.class, LanguageAssistance.class).build(LanguageAssistFactory.class));
    }

    @Provides
    @Singleton
    public TLauncher getTlauncher() {
        try {
            return ((TlauncherFactory)TLauncher.getInjector().getInstance(TlauncherFactory.class)).create(this.set);
        }
        catch (Throwable e) {
            if (TlauncherUtil.getStringError(e).contains("Problem reading font data.")) {
                String text = Localizable.get("alert.error.font.problem").replaceAll("pageLang", TlauncherUtil.getPageLanguage());
                Alert.showErrorHtml(text, 400);
                TLauncher.kill();
            } else {
                U.log("can't create TLauncher instance", e);
            }
            throw new NullPointerException("can't create TLauncher instance");
        }
    }

    @Provides
    @Singleton
    public Gson getGson() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting();
        return builder.create();
    }

    @Provides
    @Singleton
    public DoubleRunningTimer getDoubleRunningTimer() {
        return new DoubleRunningTimer();
    }

    private Gson createGsonCompleteVersion() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)CompleteVersion.class), new CompleteVersion.CompleteVersionSerializer());
        builder.registerTypeAdapter((Type)((Object)ModpackDTO.class), new ModpackDTOTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)ModDTO.class), new ModDTOTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)MapDTO.class), new MapDTOTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)ResourcePackDTO.class), new ResourcePackDTOTypeAdapter());
        builder.enableComplexMapKeySerialization();
        builder.setPrettyPrinting();
        return builder.create();
    }

    private Gson createAddittionalFileGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter((Type)((Object)Pattern.class), new PatternTypeAdapter());
        builder.setPrettyPrinting();
        return builder.create();
    }
}

