/*
 * Decompiled with CFR 0.152.
 */
package me.desmin88.mobdisguise.api;

import me.desmin88.mobdisguise.MobDisguise;
import me.desmin88.mobdisguise.api.event.DisguiseAsMobEvent;
import me.desmin88.mobdisguise.api.event.DisguiseAsPlayerEvent;
import me.desmin88.mobdisguise.api.event.UnDisguiseEvent;
import me.desmin88.mobdisguise.utils.Disguise;
import net.minecraft.server.DataWatcher;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class MobDisguiseAPI {
    public static boolean disguisePlayerAsPlayer(Player p, String name) {
        if (MobDisguiseAPI.isDisguised(p)) {
            return false;
        }
        if (name.length() > 16) {
            String tmp;
            System.out.println("[MobDisguise] Error, some other plugin is setting a name over 16 characters, truncating.");
            name = tmp = name.substring(0, 16);
        }
        DisguiseAsPlayerEvent e = new DisguiseAsPlayerEvent("DisguiseAsPlayerEvent", p, name);
        Bukkit.getServer().getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        MobDisguise.apiList.add(p.getName());
        MobDisguise.disList.add(p.getName());
        MobDisguise.playerdislist.add(p.getName());
        MobDisguise.pu.disguisep2pToAll(p, name);
        MobDisguise.p2p.put(p.getName(), name);
        return true;
    }

    public static boolean undisguisePlayerAsPlayer(Player p, String name) {
        if (!MobDisguiseAPI.isDisguised(p)) {
            return false;
        }
        UnDisguiseEvent e = new UnDisguiseEvent("UnDisguiseEvent", p, false);
        Bukkit.getServer().getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        MobDisguise.apiList.remove(p.getName());
        MobDisguise.disList.remove(p.getName());
        MobDisguise.playerdislist.remove(p.getName());
        MobDisguise.pu.undisguisep2pToAll(p);
        MobDisguise.p2p.put(p.getName(), null);
        return true;
    }

    public static boolean disguisePlayer(Player p, String mobtype) {
        if (!Disguise.MobType.isMob(mobtype)) {
            return false;
        }
        if (MobDisguiseAPI.isDisguised(p)) {
            return false;
        }
        Disguise disguise = new Disguise(Disguise.MobType.getMobType(mobtype), null);
        DisguiseAsMobEvent e = new DisguiseAsMobEvent("DisguiseAsMobEvent", p, disguise);
        Bukkit.getServer().getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        MobDisguise.apiList.add(p.getName());
        MobDisguise.disList.add(p.getName());
        MobDisguise.playerMobDis.put(p.getName(), disguise);
        MobDisguise.playerEntIds.add(p.getEntityId());
        MobDisguise.pu.disguiseToAll(p);
        return true;
    }

    public static boolean undisguisePlayer(Player p) {
        if (!MobDisguiseAPI.isDisguised(p)) {
            return false;
        }
        UnDisguiseEvent e = new UnDisguiseEvent("UnDisguiseEvent", p, true);
        Bukkit.getServer().getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return false;
        }
        MobDisguise.pu.undisguiseToAll(p);
        MobDisguise.disList.remove(p.getName());
        MobDisguise.apiList.remove(p.getName());
        MobDisguise.playerMobDis.put(p.getName(), null);
        MobDisguise.playerEntIds.remove(p.getEntityId());
        return true;
    }

    public static boolean isDisguised(Player p) {
        return MobDisguise.disList.contains(p.getName());
    }

    public static DataWatcher getPlayerDataWatcher(Player p) {
        if (MobDisguise.data.get(p.getName()) == null) {
            return null;
        }
        return MobDisguise.data.get(p.getName());
    }
}

