/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth;

import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MessageHandler {
    private final xAuth plugin;
    private final String fileName = "messages.yml";
    private final File configFile;
    private FileConfiguration config = null;

    public MessageHandler(xAuth plugin) {
        this.plugin = plugin;
        this.configFile = new File(plugin.getDataFolder(), "messages.yml");
    }

    public FileConfiguration getConfig() {
        if (this.config == null) {
            this.reloadConfig();
        }
        return this.config;
    }

    public void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defConfigStream = this.plugin.getResource("messages.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((InputStream)defConfigStream);
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public void saveConfig() {
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException e) {
            xAuthLog.severe("Could not save message configuration to " + this.configFile, e);
        }
    }

    public void sendMessage(String node, CommandSender sender) {
        this.sendMessage(node, sender, null);
    }

    public void sendMessage(String node, CommandSender sender, String targetName) {
        if (sender != null) {
            String message = this.get(node, sender.getName(), targetName);
            String[] stringArray = message.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                sender.sendMessage(line);
                ++n2;
            }
        }
    }

    public String get(String node) {
        return this.get(node, null, null);
    }

    private String get(String node, String playerName, String targetName) {
        return this.replace(this.config.getString(node, node), playerName, targetName);
    }

    private String replace(String message, String playerName, String targetName) {
        message = message.replace("{BLACK}", "&0");
        message = message.replace("{DARKBLUE}", "&1");
        message = message.replace("{DARKGREEN}", "&2");
        message = message.replace("{DARKTEAL}", "&3");
        message = message.replace("{DARKRED}", "&4");
        message = message.replace("{PURPLE}", "&5");
        message = message.replace("{GOLD}", "&6");
        message = message.replace("{GRAY}", "&7");
        message = message.replace("{DARKGRAY}", "&8");
        message = message.replace("{BLUE}", "&9");
        message = message.replace("{BRIGHTGREEN}", "&a");
        message = message.replace("{TEAL}", "&b");
        message = message.replace("{RED}", "&c");
        message = message.replace("{PINK}", "&d");
        message = message.replace("{YELLOW}", "&e");
        message = message.replace("{WHITE}", "&f");
        message = message.replace("&", "\u00a7");
        if (playerName != null) {
            message = message.replace("{PLAYER}", playerName);
        }
        if (targetName != null) {
            message = message.replace("{TARGET}", targetName);
        }
        message = message.replace("{PWMINLENGTH}", String.valueOf(this.plugin.getConfig().getInt("password.min-length")));
        message = message.replace("{NEWLINE}", "\n");
        return message;
    }
}

