/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth;

import com.cypherx.xauth.database.Table;
import com.cypherx.xauth.plugins.xPermissions;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import com.cypherx.xauth.xAuthPlayer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;

public class PlayerManager {
    private final xAuth plugin;
    private final ConcurrentMap<String, xAuthPlayer> players = new ConcurrentHashMap<String, xAuthPlayer>();

    public PlayerManager(xAuth plugin) {
        this.plugin = plugin;
    }

    public xAuthPlayer getPlayer(Player player) {
        return this.getPlayer(player, false);
    }

    public xAuthPlayer getPlayer(Player player, boolean reload) {
        return this.getPlayer(player.getName(), reload);
    }

    public xAuthPlayer getPlayer(String playerName) {
        return this.getPlayer(playerName, false);
    }

    private xAuthPlayer getPlayer(String playerName, boolean reload) {
        String lowPlayerName = playerName.toLowerCase();
        if (this.players.containsKey(lowPlayerName) && !reload) {
            return (xAuthPlayer)this.players.get(lowPlayerName);
        }
        xAuthPlayer player = this.loadPlayer(playerName);
        if (player == null) {
            player = new xAuthPlayer(playerName);
        }
        this.players.put(lowPlayerName, player);
        return player;
    }

    private xAuthPlayer loadPlayer(String playerName) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block5: {
            conn = this.plugin.getDbCtrl().getConnection();
            ps = null;
            rs = null;
            String sql = String.format("SELECT `id` FROM `%s` WHERE `playername` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setString(1, playerName);
            rs = ps.executeQuery();
            if (rs.next()) break block5;
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return null;
        }
        try {
            xAuthPlayer xAuthPlayer2 = new xAuthPlayer(playerName, rs.getInt("id"));
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return xAuthPlayer2;
        }
        catch (SQLException e) {
            try {
                xAuthLog.severe(String.format("Failed to load player: %s", playerName), e);
                this.plugin.getDbCtrl().close(conn, ps, rs);
                return null;
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps, rs);
                throw throwable;
            }
        }
    }

    public void handleReload(Player[] players) {
        Player[] playerArray = players;
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player p = playerArray[n2];
            xAuthPlayer xp = this.getPlayer(p.getName());
            boolean mustLogin = false;
            if (xp.isRegistered()) {
                if (!this.checkSession(xp)) {
                    mustLogin = true;
                    this.plugin.getAuthClass(xp).offline(p.getName());
                } else {
                    xp.setStatus(xAuthPlayer.Status.Authenticated);
                    this.plugin.getAuthClass(xp).online(p.getName());
                }
            } else if (this.mustRegister(p)) {
                mustLogin = true;
                this.plugin.getAuthClass(xp).offline(p.getName());
            }
            if (mustLogin) {
                this.protect(xp);
                this.plugin.getMsgHndlr().sendMessage("misc.reloaded", (CommandSender)p);
            }
            ++n2;
        }
    }

    public boolean mustRegister(Player player) {
        if (this.plugin.getConfig().getBoolean("authurl.enabled")) {
            return this.plugin.getConfig().getBoolean("authurl.registration");
        }
        return this.plugin.getConfig().getBoolean("registration.forced") || xPermissions.has((CommandSender)player, "xauth.register");
    }

    public boolean checkSession(xAuthPlayer player) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block8: {
            block7: {
                if (!this.plugin.getDbCtrl().isTableActive(Table.SESSION)) {
                    return false;
                }
                conn = this.plugin.getDbCtrl().getConnection();
                ps = null;
                rs = null;
                String sql = String.format("SELECT `ipaddress`, `logintime` FROM `%s` WHERE `accountid` = ?", this.plugin.getDbCtrl().getTable(Table.SESSION));
                ps = conn.prepareStatement(sql);
                ps.setInt(1, player.getAccountId());
                rs = ps.executeQuery();
                if (rs.next()) break block7;
                this.plugin.getDbCtrl().close(conn, ps, rs);
                return false;
            }
            String ipAddress = rs.getString("ipaddress");
            Timestamp loginTime = rs.getTimestamp("logintime");
            boolean valid = this.isSessionValid(player, ipAddress, loginTime);
            if (!valid) break block8;
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return true;
        }
        try {
            this.deleteSession(player.getAccountId());
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return false;
        }
        catch (SQLException e) {
            try {
                xAuthLog.severe(String.format("Failed to load session for account: %d", player.getAccountId()), e);
                this.plugin.getDbCtrl().close(conn, ps, rs);
                return false;
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps, rs);
                throw throwable;
            }
        }
    }

    private boolean isSessionValid(xAuthPlayer xp, String ipAddress, Timestamp loginTime) {
        if (this.plugin.getConfig().getBoolean("session.verifyip") && !ipAddress.equals(xp.getIPAddress())) {
            return false;
        }
        Timestamp expireTime = new Timestamp(loginTime.getTime() + (long)(this.plugin.getConfig().getInt("session.length") * 1000));
        return expireTime.compareTo(new Timestamp(System.currentTimeMillis())) > 0;
    }

    public void protect(xAuthPlayer xp) {
        Player p = xp.getPlayer();
        if (p == null) {
            return;
        }
        this.plugin.getPlyrDtHndlr().storeData(xp, p);
        xp.setCreative(p.getGameMode().equals((Object)GameMode.CREATIVE));
        if (xp.isCreativeMode()) {
            p.setGameMode(GameMode.SURVIVAL);
        }
        xp.setLastNotifyTime(new Timestamp(System.currentTimeMillis()));
        int timeout = this.plugin.getConfig().getInt("guest.timeout");
        if (timeout > 0 && xp.isRegistered()) {
            xp.setTimeoutTaskId(this.scheduleTimeoutTask(p, timeout));
        }
        xp.setProtected(true);
    }

    private int scheduleTimeoutTask(final Player player, int timeout) {
        return Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                if (player.isOnline()) {
                    player.kickPlayer(PlayerManager.this.plugin.getMsgHndlr().get("misc.timeout"));
                }
            }
        }, (long)(this.plugin.getConfig().getInt("guest.timeout") * 20));
    }

    public void unprotect(xAuthPlayer xp) {
        int timeoutTaskId;
        Player p = xp.getPlayer();
        this.plugin.getPlyrDtHndlr().restoreData(xp, p);
        if (xp.isCreativeMode()) {
            p.setGameMode(GameMode.CREATIVE);
        }
        if ((timeoutTaskId = xp.getTimeoutTaskId()) > -1) {
            Bukkit.getScheduler().cancelTask(timeoutTaskId);
            xp.setTimeoutTaskId(-1);
        }
        xp.setProtected(false);
    }

    public boolean isRestricted(xAuthPlayer player, Event event) {
        if (!player.isProtected()) {
            return false;
        }
        boolean restrict = true;
        String[] split = event.getEventName().split("\\.");
        String eventName = split[split.length - 1];
        split = eventName.split("(?=\\p{Upper})");
        String type = split[1].toLowerCase();
        String action = split[2].toLowerCase();
        String restrictNode = String.format("restrict.%s.%s", type, action);
        String allowNode = String.format("allow.%s.%s", type, action);
        if (this.plugin.getConfig().contains("guest." + restrictNode)) {
            if (!this.plugin.getConfig().getBoolean("guest." + restrictNode)) {
                restrict = false;
            }
            if (xPermissions.has((CommandSender)player.getPlayer(), "xauth." + restrictNode)) {
                restrict = true;
            } else if (xPermissions.has((CommandSender)player.getPlayer(), "xauth." + allowNode)) {
                restrict = false;
            }
        }
        return restrict;
    }

    public void sendNotice(xAuthPlayer player) {
        if (this.canNotify(player)) {
            this.plugin.getMsgHndlr().sendMessage("misc.illegal", (CommandSender)player.getPlayer());
            player.setLastNotifyTime(new Timestamp(System.currentTimeMillis()));
        }
    }

    private boolean canNotify(xAuthPlayer player) {
        Timestamp lastNotifyTime = player.getLastNotifyTime();
        if (lastNotifyTime == null) {
            return true;
        }
        Timestamp nextNotifyTime = new Timestamp(lastNotifyTime.getTime() + (long)(this.plugin.getConfig().getInt("guest.notify-cooldown") * 1000));
        return nextNotifyTime.compareTo(new Timestamp(System.currentTimeMillis())) < 0;
    }

    public boolean hasGodmode(xAuthPlayer player, EntityDamageEvent.DamageCause cause) {
        int godmodeLength = this.plugin.getConfig().getInt("session.godmode-length");
        Timestamp loginTime = player.getLoginTime();
        if (godmodeLength < 1 || loginTime == null || cause == EntityDamageEvent.DamageCause.FIRE_TICK || cause == EntityDamageEvent.DamageCause.DROWNING) {
            return false;
        }
        Timestamp expireTime = new Timestamp(loginTime.getTime() + (long)(godmodeLength * 1000));
        return expireTime.compareTo(new Timestamp(System.currentTimeMillis())) > 0;
    }

    public boolean isActive(int id) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            if (!this.plugin.getConfig().getBoolean("registration.activation")) {
                return true;
            }
            conn = this.plugin.getDbCtrl().getConnection();
            ps = null;
            rs = null;
            String sql = String.format("SELECT `active` FROM `%s` WHERE `id` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setInt(1, id);
            rs = ps.executeQuery();
            if (rs.next()) break block6;
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return false;
        }
        try {
            boolean bl = rs.getBoolean("active");
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return bl;
        }
        catch (SQLException e) {
            try {
                xAuthLog.severe("Failed to check active status of account: " + id, e);
                this.plugin.getDbCtrl().close(conn, ps, rs);
                return false;
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps, rs);
                throw throwable;
            }
        }
    }

    public boolean activateAcc(int id) {
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        try {
            String sql = String.format("UPDATE `%s` SET `active` = 1 WHERE `id` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setInt(1, id);
            ps.executeUpdate();
            this.plugin.getDbCtrl().close(conn, ps);
            return true;
        }
        catch (SQLException e) {
            try {
                xAuthLog.severe("Failed to activate account: " + id, e);
                this.plugin.getDbCtrl().close(conn, ps);
                return false;
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps);
                throw throwable;
            }
        }
    }

    public boolean doLogin(xAuthPlayer xp) {
        int accountId = xp.getAccountId();
        String ipAddress = xp.getIPAddress();
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        try {
            if (this.plugin.getConfig().getBoolean("authurl.enabled") && accountId < 1) {
                accountId = this.createAccount(xp.getPlayerName(), "authURL", null, ipAddress);
                xp.setAccountId(accountId);
                xp.setStatus(xAuthPlayer.Status.Registered);
            }
            if (this.plugin.getConfig().getBoolean("account.track-last-login")) {
                this.updateLastLogin(accountId, ipAddress, currentTime);
            }
            if (this.plugin.getDbCtrl().isTableActive(Table.SESSION)) {
                this.createSession(accountId, ipAddress);
            }
            this.plugin.getStrkMngr().getRecord(ipAddress).clearStrikes(xp.getPlayerName());
            this.unprotect(xp);
            xp.setLoginTime(currentTime);
            xp.setStatus(xAuthPlayer.Status.Authenticated);
            return true;
        }
        catch (SQLException e) {
            xAuthLog.severe("Something went wrong while logging in player: " + xp.getPlayerName(), e);
            return false;
        }
    }

    public int createAccount(String user, String pass, String email, String ipaddress) throws SQLException {
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String sql = String.format("INSERT INTO `%s` (`playername`, `password`, `email`, `registerdate`, `registerip`) VALUES (?, ?, ?, ?, ?)", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
            ps = conn.prepareStatement(sql, 1);
            ps.setString(1, user);
            ps.setString(2, this.plugin.getPwdHndlr().hash(pass));
            ps.setString(3, email);
            ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
            ps.setString(5, ipaddress);
            ps.executeUpdate();
            rs = ps.getGeneratedKeys();
            int n = rs.next() ? rs.getInt(1) : -1;
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return n;
        }
        catch (Throwable throwable) {
            this.plugin.getDbCtrl().close(conn, ps, rs);
            throw throwable;
        }
    }

    public boolean updateLastLogin(int accountId, String ipAddress, Timestamp currentTime) throws SQLException {
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        try {
            String sql = String.format("UPDATE `%s` SET `lastlogindate` = ?, `lastloginip` = ? WHERE `id` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setTimestamp(1, currentTime);
            ps.setString(2, ipAddress);
            ps.setInt(3, accountId);
            ps.executeUpdate();
            this.plugin.getDbCtrl().close(conn, ps);
            return true;
        }
        catch (Throwable throwable) {
            this.plugin.getDbCtrl().close(conn, ps);
            throw throwable;
        }
    }

    public boolean deleteAccount(int accountId) {
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        try {
            String sql = String.format("DELETE FROM `%s` WHERE `id` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setInt(1, accountId);
            ps.executeUpdate();
            this.plugin.getDbCtrl().close(conn, ps);
            return true;
        }
        catch (SQLException e) {
            try {
                xAuthLog.severe("Something went wrong while deleting account: " + accountId, e);
                this.plugin.getDbCtrl().close(conn, ps);
                return false;
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps);
                throw throwable;
            }
        }
    }

    public boolean createSession(int accountId, String ipAddress) throws SQLException {
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        try {
            String sql = String.format("INSERT INTO `%s` VALUES (?, ?, ?)", this.plugin.getDbCtrl().getTable(Table.SESSION));
            ps = conn.prepareStatement(sql);
            ps.setInt(1, accountId);
            ps.setString(2, ipAddress);
            ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            ps.executeUpdate();
            this.plugin.getDbCtrl().close(conn, ps);
            return true;
        }
        catch (Throwable throwable) {
            this.plugin.getDbCtrl().close(conn, ps);
            throw throwable;
        }
    }

    public boolean deleteSession(int accountId) {
        if (!this.plugin.getDbCtrl().isTableActive(Table.SESSION)) {
            return true;
        }
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        try {
            String sql = String.format("DELETE FROM `%s` WHERE `accountid` = ?", this.plugin.getDbCtrl().getTable(Table.SESSION));
            ps = conn.prepareStatement(sql);
            ps.setInt(1, accountId);
            ps.executeUpdate();
            this.plugin.getDbCtrl().close(conn, ps);
            return true;
        }
        catch (SQLException e) {
            try {
                xAuthLog.severe("Something went wrong while deleting session for account: " + accountId, e);
                this.plugin.getDbCtrl().close(conn, ps);
                return false;
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps);
                throw throwable;
            }
        }
    }

    public void reload() {
        this.players.clear();
    }
}

