/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.listeners;

import com.cypherx.xauth.PlayerManager;
import com.cypherx.xauth.Utils;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthPlayer;
import java.sql.Timestamp;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class xAuthPlayerListener
implements Listener {
    private final xAuth plugin;
    private final PlayerManager plyrMngr;

    public xAuthPlayerListener(xAuth plugin) {
        this.plugin = plugin;
        this.plyrMngr = plugin.getPlyrMngr();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerLogin(PlayerLoginEvent event) {
        String ipAddress;
        if (!event.getResult().equals((Object)PlayerLoginEvent.Result.ALLOWED)) {
            return;
        }
        Player p = event.getPlayer();
        if (p.isOnline()) {
            xAuthPlayer xp = this.plyrMngr.getPlayer(p);
            boolean reverse = this.plugin.getConfig().getBoolean("single-session.reverse");
            if (reverse && !xp.isAuthenticated() && !this.plugin.getConfig().getBoolean("single-session.guests.reverse")) {
                Timestamp expireTime = new Timestamp(xp.getConnectTime().getTime() + (long)(this.plugin.getConfig().getInt("single-session.guests.immunity-length") * 1000));
                boolean bl = reverse = expireTime.compareTo(new Timestamp(System.currentTimeMillis())) >= 0;
            }
            if (reverse) {
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.plugin.getMsgHndlr().get("join.error.online"));
            }
        }
        if (Utils.isIPAddress(ipAddress = event.getAddress().getHostAddress()) && this.plugin.getStrkMngr().isLockedOut(ipAddress, p.getName())) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.plugin.getMsgHndlr().get("join.error.lockout"));
        }
        if (!this.isValidName(p.getName())) {
            event.disallow(PlayerLoginEvent.Result.KICK_OTHER, this.plugin.getMsgHndlr().get("join.error.name"));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player p = event.getPlayer();
        if (p == null || !p.isOnline()) {
            return;
        }
        xAuthPlayer xp = this.plyrMngr.getPlayer(p, this.plugin.getConfig().getBoolean("main.reload-on-join"));
        xp.setConnectTime(new Timestamp(System.currentTimeMillis()));
        String node = "";
        boolean protect = false;
        if (xp.isRegistered() || this.plugin.isAuthURL()) {
            if (this.plyrMngr.checkSession(xp)) {
                xp.setStatus(xAuthPlayer.Status.Authenticated);
                this.plugin.getAuthClass(xp).online(p.getName());
                node = "join.resume";
            } else {
                xp.setStatus(xAuthPlayer.Status.Registered);
                node = "join.login";
                protect = true;
            }
        } else if (this.plyrMngr.mustRegister(p)) {
            xp.setStatus(xAuthPlayer.Status.Guest);
            node = "join.register";
            protect = true;
        }
        if (protect) {
            xp.setProtected(true);
            this.scheduleDelayedProtect(xp);
        }
        if (!node.isEmpty()) {
            this.sendDelayedMessage(p, node, 1);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerQuit(PlayerQuitEvent event) {
        xAuthPlayer p = this.plyrMngr.getPlayer(event.getPlayer());
        if (p.isProtected()) {
            this.plyrMngr.unprotect(p);
        }
        this.plugin.getAuthClass(p).offline(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerChat(PlayerChatEvent event) {
        xAuthPlayer p = this.plyrMngr.getPlayer(event.getPlayer());
        if (this.plyrMngr.isRestricted(p, (Event)event)) {
            this.plyrMngr.sendNotice(p);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        xAuthPlayer p = this.plyrMngr.getPlayer(event.getPlayer().getName());
        if (this.plyrMngr.isRestricted(p, (Event)event)) {
            String command = event.getMessage().split(" ")[0].replaceFirst("/", "");
            if (!this.plugin.getConfig().getStringList("guest.allowed-commands").contains(command)) {
                this.plyrMngr.sendNotice(p);
                event.setMessage("/");
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        xAuthPlayer p;
        if (!this.plugin.getConfig().getBoolean("guest.hide-inventory") && this.plyrMngr.isRestricted(p = this.plyrMngr.getPlayer(event.getPlayer()), (Event)event)) {
            this.plyrMngr.sendNotice(p);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        xAuthPlayer p = this.plyrMngr.getPlayer(event.getPlayer().getName());
        if (this.plyrMngr.isRestricted(p, (Event)event)) {
            Action action = event.getAction();
            Material type = event.getClickedBlock().getType();
            if (action == Action.LEFT_CLICK_BLOCK) {
                if (type == Material.NOTE_BLOCK || type == Material.WOODEN_DOOR || type == Material.LEVER || type == Material.IRON_DOOR || type == Material.STONE_BUTTON || type == Material.TRAP_DOOR) {
                    this.plyrMngr.sendNotice(p);
                    event.setCancelled(true);
                }
            } else if (action == Action.RIGHT_CLICK_BLOCK) {
                if (type == Material.DISPENSER || type == Material.NOTE_BLOCK || type == Material.BED || type == Material.CHEST || type == Material.WORKBENCH || type == Material.FURNACE || type == Material.SIGN || type == Material.WOODEN_DOOR || type == Material.LEVER || type == Material.IRON_DOOR || type == Material.STONE_BUTTON || type == Material.JUKEBOX || type == Material.TRAP_DOOR || type == Material.ENCHANTMENT_TABLE) {
                    this.plyrMngr.sendNotice(p);
                    event.setCancelled(true);
                }
            } else if (action == Action.PHYSICAL && (type == Material.SOIL || type == Material.STONE_PLATE || type == Material.WOOD_PLATE)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        xAuthPlayer p = this.plyrMngr.getPlayer(event.getPlayer());
        if (this.plyrMngr.isRestricted(p, (Event)event)) {
            World w = p.getPlayer().getWorld();
            Location loc = this.plugin.getConfig().getBoolean("guest.protect-location") ? this.plugin.getLocMngr().getLocation(w) : p.getPlayerData().getLocation();
            Location testLoc = new Location(loc.getWorld(), loc.getX(), loc.getY(), loc.getZ());
            while ((w.getBlockAt(testLoc).isEmpty() || w.getBlockAt(testLoc).isLiquid()) && testLoc.getY() >= 0.0) {
                testLoc.setY((double)((int)testLoc.getY() - 1));
            }
            if (testLoc.getY() > 0.0) {
                loc.setY(testLoc.getY() + 1.0);
            }
            event.setTo(loc);
            this.plyrMngr.sendNotice(p);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        xAuthPlayer p = this.plyrMngr.getPlayer(event.getPlayer());
        if (this.plyrMngr.isRestricted(p, (Event)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        xAuthPlayer p;
        HumanEntity entity;
        if (!this.plugin.getConfig().getBoolean("guest.hide-inventory") && (entity = event.getWhoClicked()) instanceof Player && this.plyrMngr.isRestricted(p = this.plyrMngr.getPlayer(((Player)entity).getName()), (Event)event)) {
            this.plyrMngr.sendNotice(p);
            event.setCancelled(true);
        }
    }

    private boolean isValidName(String pName) {
        String disallowed;
        if (pName.length() < this.plugin.getConfig().getInt("filter.min-length")) {
            return false;
        }
        String allowed = this.plugin.getConfig().getString("filter.allowed");
        if (allowed.length() > 0) {
            int i = 0;
            while (i < pName.length()) {
                if (allowed.indexOf(pName.charAt(i)) == -1) {
                    return false;
                }
                ++i;
            }
        }
        if ((disallowed = this.plugin.getConfig().getString("filter.disallowed")).length() > 0) {
            int i = 0;
            while (i < pName.length()) {
                if (disallowed.indexOf(pName.charAt(i)) >= 0) {
                    return false;
                }
                ++i;
            }
        }
        return !this.plugin.getConfig().getBoolean("filter.blank-name") || !Utils.isWhitespace(pName);
    }

    private void scheduleDelayedProtect(final xAuthPlayer xp) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                xAuthPlayerListener.this.plyrMngr.protect(xp);
            }
        }, 1L);
    }

    private void sendDelayedMessage(final Player player, final String node, int delay) {
        Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                if (player.isOnline()) {
                    xAuthPlayerListener.this.plugin.getMsgHndlr().sendMessage(node, (CommandSender)player);
                }
            }
        }, (long)delay);
    }
}

