/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.strike;

import com.cypherx.xauth.database.Table;
import com.cypherx.xauth.strike.StrikeRecord;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class StrikeManager {
    private final xAuth plugin;
    private Map<String, StrikeRecord> strikeRecords = new HashMap<String, StrikeRecord>();

    public StrikeManager(xAuth plugin) {
        this.plugin = plugin;
    }

    public StrikeRecord getRecord(String ipAddress) {
        if (this.strikeRecords.containsKey(ipAddress)) {
            return this.strikeRecords.get(ipAddress);
        }
        StrikeRecord record = new StrikeRecord();
        this.strikeRecords.put(ipAddress, record);
        return record;
    }

    public void strikeout(Player player) {
        block6: {
            player.kickPlayer(this.plugin.getMsgHndlr().get("misc.strikeout"));
            xAuthLog.info(String.valueOf(player.getName()) + " kicked for passing the incorrect password threshold");
            if (this.plugin.getConfig().getInt("strikes.lockout-length") > 0) {
                String ipAddress = player.getAddress().getAddress().getHostAddress();
                String playerName = player.getName();
                Connection conn = this.plugin.getDbCtrl().getConnection();
                PreparedStatement ps = null;
                try {
                    try {
                        String sql = String.format("INSERT INTO `%s` (`ipaddress`, `playername`, `time`) VALUES (?, ?, ?)", this.plugin.getDbCtrl().getTable(Table.LOCKOUT));
                        ps = conn.prepareStatement(sql);
                        ps.setString(1, ipAddress);
                        ps.setString(2, playerName);
                        ps.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                        ps.executeUpdate();
                    }
                    catch (SQLException e) {
                        xAuthLog.severe(String.format("Failed to insert lockout record for player: %s (%s)", playerName, ipAddress), e);
                        this.plugin.getDbCtrl().close(conn, ps);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    this.plugin.getDbCtrl().close(conn, ps);
                    throw throwable;
                }
                this.plugin.getDbCtrl().close(conn, ps);
            }
        }
    }

    public boolean isLockedOut(String ipAddress, String playerName) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        block6: {
            if (this.plugin.getConfig().getInt("strikes.lockout-length") < 1) {
                return false;
            }
            conn = this.plugin.getDbCtrl().getConnection();
            ps = null;
            rs = null;
            String sql = String.format("SELECT `time` FROM `%s` WHERE `ipaddress` = ? AND `playername` = ?", this.plugin.getDbCtrl().getTable(Table.LOCKOUT));
            ps = conn.prepareStatement(sql);
            ps.setString(1, ipAddress);
            ps.setString(2, playerName);
            rs = ps.executeQuery();
            if (rs.next()) break block6;
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return false;
        }
        try {
            Timestamp lockoutTime = rs.getTimestamp("time");
            Timestamp expireTime = new Timestamp(lockoutTime.getTime() + (long)(this.plugin.getConfig().getInt("strikes.lockout-length") * 1000));
            boolean bl = expireTime.compareTo(new Timestamp(System.currentTimeMillis())) > 0;
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return bl;
        }
        catch (SQLException e) {
            try {
                xAuthLog.severe(String.format("Failed to load lockout time for player: %s (%s)", playerName, ipAddress), e);
                this.plugin.getDbCtrl().close(conn, ps, rs);
                return false;
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps, rs);
                throw throwable;
            }
        }
    }
}

