/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth;

import com.cypherx.xauth.PlayerData;
import java.sql.Timestamp;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class xAuthPlayer {
    private String playerName;
    private int accountId = 0;
    private Status status = Status.Guest;
    private PlayerData playerData;
    private Timestamp lastNotifyTime;
    private Timestamp loginTime;
    private boolean creativeMode;
    private int timeoutTaskId = -1;
    private boolean isProtected = false;
    private Timestamp connectTime;

    public xAuthPlayer(String playerName) {
        this.playerName = playerName;
    }

    public xAuthPlayer(String playerName, int accountId) {
        this.playerName = playerName;
        this.accountId = accountId;
        this.status = Status.Registered;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public Player getPlayer() {
        return Bukkit.getServer().getPlayerExact(this.playerName);
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public PlayerData getPlayerData() {
        return this.playerData;
    }

    public void setPlayerData(PlayerData playerData) {
        this.playerData = playerData;
    }

    public Timestamp getLastNotifyTime() {
        return this.lastNotifyTime;
    }

    public void setLastNotifyTime(Timestamp lastNotifyTime) {
        this.lastNotifyTime = lastNotifyTime;
    }

    public Timestamp getLoginTime() {
        return this.loginTime;
    }

    public void setLoginTime(Timestamp loginTime) {
        this.loginTime = loginTime;
    }

    public boolean isCreativeMode() {
        return this.creativeMode;
    }

    public void setCreative(boolean creativeMode) {
        this.creativeMode = creativeMode;
    }

    public int getTimeoutTaskId() {
        return this.timeoutTaskId;
    }

    public void setTimeoutTaskId(int timeoutTaskId) {
        this.timeoutTaskId = timeoutTaskId;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public Timestamp getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(Timestamp connectTime) {
        this.connectTime = connectTime;
    }

    public boolean isGuest() {
        return this.status == Status.Guest;
    }

    public boolean isRegistered() {
        return this.status != Status.Guest;
    }

    public boolean isAuthenticated() {
        return this.status == Status.Authenticated;
    }

    public String getIPAddress() {
        Player player = this.getPlayer();
        if (player == null) {
            return null;
        }
        try {
            return player.getAddress().getAddress().getHostAddress();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        Guest,
        Registered,
        Authenticated;

    }
}

