/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineTokenizer {
    private CommandLineTokenizer() {
    }

    private static void appendToBuffer(List<String> resultBuffer, StringBuffer buf) {
        if (buf.length() > 0) {
            resultBuffer.add(buf.toString());
            buf.setLength(0);
        }
    }

    public static String[] tokenize(String[] args) {
        if (args == null || args.length == 0) {
            return CommandLineTokenizer.tokenize("");
        }
        StringBuilder sb = new StringBuilder(args[0]);
        int i = 1;
        while (i < args.length) {
            sb.append(" ").append(args[i]);
            ++i;
        }
        return CommandLineTokenizer.tokenize(sb.toString());
    }

    public static String[] tokenize(String commandLine) {
        ArrayList<String> resultBuffer = new ArrayList<String>();
        if (commandLine != null) {
            int z = commandLine.length();
            boolean insideQuotes = false;
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < z) {
                char c = commandLine.charAt(i);
                if (c == '\"') {
                    CommandLineTokenizer.appendToBuffer(resultBuffer, buf);
                    insideQuotes = !insideQuotes;
                } else if (c == '\\') {
                    if (z > i + 1 && (commandLine.charAt(i + 1) == '\"' || commandLine.charAt(i + 1) == '\\')) {
                        buf.append(commandLine.charAt(i + 1));
                        ++i;
                    } else {
                        buf.append("\\");
                    }
                } else if (insideQuotes) {
                    buf.append(c);
                } else if (Character.isWhitespace(c)) {
                    CommandLineTokenizer.appendToBuffer(resultBuffer, buf);
                } else {
                    buf.append(c);
                }
                ++i;
            }
            CommandLineTokenizer.appendToBuffer(resultBuffer, buf);
        }
        String[] result = new String[resultBuffer.size()];
        return resultBuffer.toArray(result);
    }
}

