/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth;

import com.cypherx.xauth.database.Table;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class LocationManager {
    private final xAuth plugin;
    private Map<UUID, Location> locations = new HashMap<UUID, Location>();
    private UUID globalUID = null;

    public LocationManager(xAuth plugin) {
        this.plugin = plugin;
        this.loadLocations();
    }

    public void loadLocations() {
        block6: {
            Connection conn = this.plugin.getDbCtrl().getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    String sql = String.format("SELECT * FROM `%s`", this.plugin.getDbCtrl().getTable(Table.LOCATION));
                    ps = conn.prepareStatement(sql);
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        UUID uid = UUID.fromString(rs.getString("uid"));
                        double x = rs.getDouble("x");
                        double y = rs.getDouble("y");
                        double z = rs.getDouble("z");
                        float yaw = rs.getFloat("yaw");
                        float pitch = rs.getFloat("pitch");
                        int global = rs.getInt("global");
                        this.locations.put(uid, new Location(Bukkit.getServer().getWorld(uid), x, y, z, yaw, pitch));
                        if (global != 1) continue;
                        this.globalUID = uid;
                    }
                }
                catch (SQLException e) {
                    xAuthLog.severe("Failed to load teleport locations!", e);
                    this.plugin.getDbCtrl().close(conn, ps, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps, rs);
                throw throwable;
            }
            this.plugin.getDbCtrl().close(conn, ps, rs);
        }
    }

    public Location getLocation(World world) {
        UUID uid = this.globalUID == null ? world.getUID() : this.globalUID;
        Location loc = this.locations.get(uid);
        return loc == null ? world.getSpawnLocation() : loc;
    }

    public boolean setLocation(Location loc, boolean global) {
        UUID uid = loc.getWorld().getUID();
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        try {
            String sql = this.plugin.getDbCtrl().isMySQL() ? String.format("INSERT INTO `%s` VALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE `uid` = VALUES(`uid`), `x` = VALUES(`x`), `y` = VALUES(`y`), `z` = VALUES(`z`), `yaw` = VALUES(`yaw`), `pitch` = VALUES(`pitch`), `global` = VALUES(`global`)", this.plugin.getDbCtrl().getTable(Table.LOCATION)) : String.format("MERGE INTO `%s` VALUES (?, ?, ?, ?, ?, ?, ?)", this.plugin.getDbCtrl().getTable(Table.LOCATION));
            ps = conn.prepareStatement(sql);
            ps.setString(1, uid.toString());
            ps.setDouble(2, loc.getX());
            ps.setDouble(3, loc.getY());
            ps.setDouble(4, loc.getZ());
            ps.setFloat(5, loc.getYaw());
            ps.setFloat(6, loc.getPitch());
            ps.setInt(7, global ? 1 : 0);
            ps.executeUpdate();
            this.locations.put(uid, loc);
            if (global) {
                this.globalUID = uid;
            } else if (!global && this.globalUID != null && this.globalUID == uid) {
                this.globalUID = null;
            }
            this.plugin.getDbCtrl().close(conn, ps);
            return true;
        }
        catch (SQLException e) {
            xAuthLog.severe("Failed to set location!", e);
            return false;
        }
        finally {
            this.plugin.getDbCtrl().close(conn, ps);
        }
    }

    public boolean removeLocation(World world) {
        UUID uid = world.getUID();
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        try {
            String sql = String.format("DELETE FROM `%s` WHERE `uid` = ?", this.plugin.getDbCtrl().getTable(Table.LOCATION));
            ps = conn.prepareStatement(sql);
            ps.setString(1, uid.toString());
            ps.executeUpdate();
            this.locations.remove(uid);
            if (uid == this.globalUID) {
                this.globalUID = null;
            }
            this.plugin.getDbCtrl().close(conn, ps);
            return true;
        }
        catch (SQLException e) {
            xAuthLog.severe("Failed to remove location!", e);
            return false;
        }
        finally {
            this.plugin.getDbCtrl().close(conn, ps);
        }
    }

    public boolean isLocationSet(World world) {
        return this.locations.containsKey(world.getUID());
    }

    public UUID getGlobalUID() {
        return this.globalUID;
    }
}

