/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth;

import com.cypherx.xauth.PlayerData;
import com.cypherx.xauth.database.Table;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import com.cypherx.xauth.xAuthPlayer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerDataHandler {
    private final xAuth plugin;

    public PlayerDataHandler(xAuth plugin) {
        this.plugin = plugin;
    }

    public void storeData(xAuthPlayer xp, Player p) {
        block10: {
            PlayerInventory pInv = p.getInventory();
            ItemStack[] items = pInv.getContents();
            ItemStack[] armor = pInv.getArmorContents();
            Location loc = p.isDead() ? null : p.getLocation();
            Collection potEffects = p.getActivePotionEffects();
            int fireTicks = p.isDead() ? 0 : p.getFireTicks();
            int remainingAir = p.getRemainingAir();
            String strItems = null;
            String strArmor = null;
            String strLoc = null;
            String strPotFx = this.buildPotFxString(potEffects);
            xp.setPlayerData(new PlayerData(items, armor, loc, potEffects, fireTicks, remainingAir));
            boolean hideInv = this.plugin.getConfig().getBoolean("guest.hide-inventory");
            boolean hideLoc = this.plugin.getConfig().getBoolean("guest.protect-location");
            if (hideInv) {
                strItems = this.buildItemString(items);
                strArmor = this.buildItemString(armor);
                pInv.clear();
                pInv.setHelmet(null);
                pInv.setChestplate(null);
                pInv.setLeggings(null);
                pInv.setBoots(null);
            }
            if (hideLoc && !p.isDead()) {
                strLoc = String.valueOf(loc.getWorld().getName()) + ":" + loc.getX() + ":" + loc.getY() + ":" + loc.getZ() + ":" + loc.getYaw() + ":" + loc.getPitch();
                p.teleport(this.plugin.getLocMngr().getLocation(p.getWorld()));
            }
            for (PotionEffect effect : p.getActivePotionEffects()) {
                p.addPotionEffect(new PotionEffect(effect.getType(), 0, 0), true);
            }
            p.setFireTicks(0);
            p.setRemainingAir(300);
            if (strItems != null || strArmor != null || strLoc != null || strPotFx != null) {
                Connection conn = this.plugin.getDbCtrl().getConnection();
                PreparedStatement ps = null;
                try {
                    try {
                        String sql = this.plugin.getDbCtrl().isMySQL() ? String.format("INSERT IGNORE INTO `%s` VALUES (?, ?, ?, ?, ?, ?, ?)", this.plugin.getDbCtrl().getTable(Table.PLAYERDATA)) : String.format("INSERT INTO `%s` SELECT ?, ?, ?, ?, ?, ?, ? FROM DUAL WHERE NOT EXISTS (SELECT * FROM `%s` WHERE `playername` = ?)", this.plugin.getDbCtrl().getTable(Table.PLAYERDATA), this.plugin.getDbCtrl().getTable(Table.PLAYERDATA));
                        ps = conn.prepareStatement(sql);
                        ps.setString(1, p.getName());
                        ps.setString(2, strItems);
                        ps.setString(3, strArmor);
                        ps.setString(4, strLoc);
                        ps.setString(5, strPotFx);
                        ps.setInt(6, fireTicks);
                        ps.setInt(7, remainingAir);
                        if (!this.plugin.getDbCtrl().isMySQL()) {
                            ps.setString(8, p.getName());
                        }
                        ps.executeUpdate();
                    }
                    catch (SQLException e) {
                        xAuthLog.severe("Failed to insert player data into database!", e);
                        this.plugin.getDbCtrl().close(conn, ps);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.plugin.getDbCtrl().close(conn, ps);
                    throw throwable;
                }
                this.plugin.getDbCtrl().close(conn, ps);
            }
        }
    }

    private String buildItemString(ItemStack[] items) {
        StringBuilder sbItems = new StringBuilder();
        StringBuilder sbAmount = new StringBuilder();
        StringBuilder sbDurability = new StringBuilder();
        StringBuilder sbEnchants = new StringBuilder();
        ItemStack[] itemStackArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack item = itemStackArray[n2];
            int itemId = 0;
            int amount = 0;
            short durability = 0;
            Map enchants = null;
            if (item != null) {
                itemId = item.getTypeId();
                amount = item.getAmount();
                durability = item.getDurability();
                enchants = item.getEnchantments();
                if (!enchants.keySet().isEmpty()) {
                    for (Enchantment enchant : enchants.keySet()) {
                        int id = enchant.getId();
                        int level = (Integer)enchants.get(enchant);
                        sbEnchants.append(String.valueOf(id) + ":" + level + "-");
                    }
                    sbEnchants.deleteCharAt(sbEnchants.lastIndexOf("-"));
                }
            }
            sbItems.append(itemId).append(",");
            sbAmount.append(amount).append(",");
            sbDurability.append(durability).append(",");
            sbEnchants.append(",");
            ++n2;
        }
        sbItems.deleteCharAt(sbItems.lastIndexOf(","));
        sbAmount.deleteCharAt(sbAmount.lastIndexOf(","));
        sbDurability.deleteCharAt(sbDurability.lastIndexOf(","));
        sbEnchants.deleteCharAt(sbEnchants.lastIndexOf(","));
        return sbItems.append(";").append((CharSequence)sbAmount).append(";").append((CharSequence)sbDurability).append(";").append((CharSequence)sbEnchants).toString();
    }

    private String buildPotFxString(Collection<PotionEffect> effects) {
        if (effects.size() < 1) {
            return null;
        }
        StringBuilder sbType = new StringBuilder();
        StringBuilder sbDur = new StringBuilder();
        StringBuilder sbAmp = new StringBuilder();
        for (PotionEffect effect : effects) {
            sbType.append(effect.getType().getId()).append(",");
            sbDur.append(effect.getDuration()).append(",");
            sbAmp.append(effect.getAmplifier()).append(",");
        }
        sbType.deleteCharAt(sbType.lastIndexOf(","));
        sbDur.deleteCharAt(sbDur.lastIndexOf(","));
        sbAmp.deleteCharAt(sbAmp.lastIndexOf(","));
        return sbType.append(";").append((CharSequence)sbDur).append(";").append((CharSequence)sbAmp).toString();
    }

    private ItemStack[] buildItemStack(String str) {
        ItemStack[] items = null;
        String[] itemSplit = str.split(";");
        String[] itemid = itemSplit[0].split(",");
        String[] amount = itemSplit[1].split(",");
        String[] durability = itemSplit[2].split(",");
        String[] enchants = itemSplit[3].split(",", -1);
        items = new ItemStack[itemid.length];
        int i = 0;
        while (i < items.length) {
            items[i] = new ItemStack(Integer.parseInt(itemid[i]), Integer.parseInt(amount[i]), Short.parseShort(durability[i]));
            if (!enchants[i].isEmpty()) {
                String[] itemEnchants;
                String[] stringArray = itemEnchants = enchants[i].split("-");
                int n = itemEnchants.length;
                int n2 = 0;
                while (n2 < n) {
                    String enchant = stringArray[n2];
                    String[] enchantSplit = enchant.split(":");
                    int id = Integer.parseInt(enchantSplit[0]);
                    int level = Integer.parseInt(enchantSplit[1]);
                    EnchantmentWrapper e = new EnchantmentWrapper(id);
                    items[i].addUnsafeEnchantment((Enchantment)e, level);
                    ++n2;
                }
            }
            ++i;
        }
        return items;
    }

    private Collection<PotionEffect> buildPotFx(String str) {
        String[] effectSplit = str.split(";");
        String[] type = effectSplit[0].split(",");
        String[] duration = effectSplit[1].split(",");
        String[] amplifier = effectSplit[2].split(",");
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        int i = 0;
        while (i < type.length) {
            PotionEffectType potFxType = PotionEffectType.getById((int)Integer.parseInt(type[i]));
            int potFxDur = Integer.parseInt(duration[i]);
            int potFxAmp = Integer.parseInt(amplifier[i]);
            effects.add(new PotionEffect(potFxType, potFxDur, potFxAmp));
            ++i;
        }
        return effects;
    }

    public void restoreData(xAuthPlayer xp, Player p) {
        block22: {
            int remainingAir;
            int fireTicks;
            Collection<PotionEffect> potFx;
            Location loc;
            ItemStack[] armor;
            ItemStack[] items;
            block20: {
                items = null;
                armor = null;
                loc = null;
                potFx = null;
                fireTicks = 0;
                remainingAir = 300;
                PlayerData playerData = xp.getPlayerData();
                if (playerData != null) {
                    items = playerData.getItems();
                    armor = playerData.getArmor();
                    loc = playerData.getLocation();
                    potFx = playerData.getPotionEffects();
                    fireTicks = playerData.getFireTicks();
                    remainingAir = playerData.getRemainingAir();
                } else {
                    Connection conn = this.plugin.getDbCtrl().getConnection();
                    PreparedStatement ps = null;
                    ResultSet rs = null;
                    try {
                        try {
                            String sql = String.format("SELECT `items`, `armor`, `location`, `potioneffects`, `fireticks`, `remainingair` FROM `%s` WHERE `playername` = ?", this.plugin.getDbCtrl().getTable(Table.PLAYERDATA));
                            ps = conn.prepareStatement(sql);
                            ps.setString(1, p.getName());
                            rs = ps.executeQuery();
                            if (rs.next()) {
                                String rsPotFx;
                                items = this.buildItemStack(rs.getString("items"));
                                armor = this.buildItemStack(rs.getString("armor"));
                                String rsLoc = rs.getString("location");
                                if (rsLoc != null) {
                                    String[] locSplit = rsLoc.split(":");
                                    loc = new Location(Bukkit.getWorld((String)locSplit[0]), Double.parseDouble(locSplit[1]), Double.parseDouble(locSplit[2]), Double.parseDouble(locSplit[3]), Float.parseFloat(locSplit[4]), Float.parseFloat(locSplit[5]));
                                }
                                if ((rsPotFx = rs.getString("potioneffects")) != null) {
                                    potFx = this.buildPotFx(rsPotFx);
                                }
                                fireTicks = rs.getInt("fireticks");
                                remainingAir = rs.getInt("remainingair");
                            }
                        }
                        catch (SQLException e) {
                            xAuthLog.severe("Failed to load playerdata from database for player: " + p.getName(), e);
                            this.plugin.getDbCtrl().close(conn, ps, rs);
                            break block20;
                        }
                    }
                    catch (Throwable throwable) {
                        this.plugin.getDbCtrl().close(conn, ps, rs);
                        throw throwable;
                    }
                    this.plugin.getDbCtrl().close(conn, ps, rs);
                }
            }
            PlayerInventory pInv = p.getInventory();
            boolean hideInv = this.plugin.getConfig().getBoolean("guest.hide-inventory");
            boolean hideLoc = this.plugin.getConfig().getBoolean("guest.protect-location");
            if (hideInv && items != null) {
                if (pInv.getSize() > items.length) {
                    ItemStack[] newItems = new ItemStack[pInv.getSize()];
                    int i = 0;
                    while (i < items.length) {
                        newItems[i] = items[i];
                        ++i;
                    }
                    items = newItems;
                }
                pInv.setContents(items);
            }
            if (hideInv && armor != null) {
                pInv.setArmorContents(armor);
            }
            if (hideLoc && loc != null && p.getHealth() > 0) {
                p.teleport(loc);
            }
            if (potFx != null) {
                p.addPotionEffects(potFx);
            }
            p.setFireTicks(fireTicks);
            p.setRemainingAir(remainingAir);
            xp.setPlayerData(null);
            Connection conn = this.plugin.getDbCtrl().getConnection();
            PreparedStatement ps = null;
            try {
                try {
                    String sql = String.format("DELETE FROM `%s` WHERE `playername` = ?", this.plugin.getDbCtrl().getTable(Table.PLAYERDATA));
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, p.getName());
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    xAuthLog.severe("Could not delete playerdata record from database for player: " + p.getName(), e);
                    this.plugin.getDbCtrl().close(conn, ps);
                    break block22;
                }
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps);
                throw throwable;
            }
            this.plugin.getDbCtrl().close(conn, ps);
        }
    }
}

