/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.auth;

import com.avaje.ebean.validation.factory.EmailValidatorFactory;
import com.cypherx.xauth.auth.Auth;
import com.cypherx.xauth.database.Table;
import com.cypherx.xauth.plugins.xPermissions;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import com.cypherx.xauth.xAuthPlayer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;

public class AuthSQL
extends Auth {
    private final xAuthPlayer player;

    public AuthSQL(xAuth plugin, xAuthPlayer player) {
        this.plugin = plugin;
        this.player = player;
    }

    public boolean login(String user, String pass) {
        if (!this.player.isRegistered()) {
            this.response = "login.error.registered";
            return false;
        }
        if (this.player.isAuthenticated()) {
            this.response = "login.error.authenticated";
            return false;
        }
        if (!this.plugin.getPwdHndlr().checkPassword(this.player.getAccountId(), pass)) {
            int strikes = this.plugin.getStrkMngr().getRecord(this.player.getIPAddress()).addStrike(this.player.getPlayerName());
            if (strikes >= this.plugin.getConfig().getInt("strikes.amount")) {
                this.plugin.getStrkMngr().strikeout(this.player.getPlayer());
            }
            this.response = "login.error.password";
            return false;
        }
        if (!this.plugin.getPlyrMngr().isActive(this.player.getAccountId())) {
            this.response = "login.error.active";
            return false;
        }
        return true;
    }

    public boolean register(String user, String pass, String email) {
        if (!this.plugin.getConfig().getBoolean("registration.enabled")) {
            this.response = "register.error.disabled";
            return false;
        }
        if (this.player.isRegistered()) {
            this.response = "register.error.registered";
            return false;
        }
        if (!this.isWithinAccLimit(this.player.getIPAddress())) {
            this.response = "register.error.limit";
            return false;
        }
        if (!this.isValidPass(pass)) {
            this.response = "register.error.password";
            return false;
        }
        if (!this.isValidEmail(email)) {
            this.response = "register.error.email";
            return false;
        }
        return this.execRegQuery(user, pass, email, false);
    }

    public boolean adminRegister(String user, String pass, String email) {
        if (this.player.isRegistered()) {
            this.response = "admin.register.error.registered";
            return false;
        }
        return this.execRegQuery(user, pass, email, true);
    }

    private boolean execRegQuery(String user, String pass, String email, boolean admin) {
        block3: {
            try {
                int accId = this.plugin.getPlyrMngr().createAccount(user, pass, email, this.player.getIPAddress());
                if (accId <= 0) break block3;
                this.player.setAccountId(accId);
                this.player.setStatus(xAuthPlayer.Status.Registered);
                this.response = admin ? "admin.register.success" : "register.success";
                return true;
            }
            catch (SQLException e) {
                xAuthLog.severe("Something went wrong while creating account for player: " + user, e);
                this.response = admin ? "admin.register.error.general" : "register.error.general";
                return false;
            }
        }
        throw new SQLException();
    }

    public boolean changePassword(String user, String oldPass, String newPass) {
        if (!this.plugin.getConfig().getBoolean("password.allow-change")) {
            this.response = "changepw.error.disabled";
            return false;
        }
        if (!this.player.isAuthenticated()) {
            this.response = "changepw.error.logged";
            return false;
        }
        if (!this.plugin.getPwdHndlr().checkPassword(this.player.getAccountId(), oldPass)) {
            this.response = "changepw.error.incorrect";
            return false;
        }
        if (!this.isValidPass(newPass)) {
            this.response = "changepw.error.invalid";
            return false;
        }
        return this.execCpwQuery(user, newPass, false);
    }

    public boolean adminChangePassword(String user, String newPass) {
        if (!this.player.isRegistered()) {
            this.response = "admin.changepw.registered";
            return false;
        }
        return this.execCpwQuery(user, newPass, true);
    }

    public boolean execCpwQuery(String user, String newPass, boolean admin) {
        Connection conn = this.plugin.getDbCtrl().getConnection();
        PreparedStatement ps = null;
        try {
            String sql = String.format("UPDATE `%s` SET `password` = ? WHERE `id` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setString(1, this.plugin.getPwdHndlr().hash(newPass));
            ps.setInt(2, this.player.getAccountId());
            ps.executeUpdate();
            this.response = admin ? "admin.changepw.success" : "changepw.success";
            this.plugin.getDbCtrl().close(conn, ps);
            return true;
        }
        catch (SQLException e) {
            try {
                xAuthLog.severe("Failed to change password for player: " + user, e);
                this.response = admin ? "admin.changepw.error.general" : "changepw.error.general";
                this.plugin.getDbCtrl().close(conn, ps);
                return false;
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps);
                throw throwable;
            }
        }
    }

    public boolean online(String user) {
        return true;
    }

    public boolean offline(String user) {
        return true;
    }

    private boolean isWithinAccLimit(String ipaddress) {
        int count;
        int limit;
        block7: {
            limit = this.plugin.getConfig().getInt("registration.account-limit");
            if (limit < 1 || xPermissions.has((CommandSender)this.player.getPlayer(), "xauth.bypass.acclimit")) {
                return true;
            }
            count = 0;
            Connection conn = this.plugin.getDbCtrl().getConnection();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                try {
                    String sql = String.format("SELECT COUNT(`id`) FROM `%s` WHERE `registerip` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, ipaddress);
                    rs = ps.executeQuery();
                    if (rs.next()) {
                        count = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    xAuthLog.severe("Could not check account count for ip: " + ipaddress, e);
                    this.plugin.getDbCtrl().close(conn, ps, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.plugin.getDbCtrl().close(conn, ps, rs);
                throw throwable;
            }
            this.plugin.getDbCtrl().close(conn, ps, rs);
        }
        return limit > count;
    }

    private boolean isValidPass(String pass) {
        String pattern = "(";
        if (this.plugin.getConfig().getBoolean("password.complexity.lowercase")) {
            pattern = String.valueOf(pattern) + "(?=.*[a-z])";
        }
        if (this.plugin.getConfig().getBoolean("password.complexity.uppercase")) {
            pattern = String.valueOf(pattern) + "(?=.*[A-Z])";
        }
        if (this.plugin.getConfig().getBoolean("password.complexity.number")) {
            pattern = String.valueOf(pattern) + "(?=.*\\d)";
        }
        if (this.plugin.getConfig().getBoolean("password.complexity.symbol")) {
            pattern = String.valueOf(pattern) + "(?=.*\\W)";
        }
        pattern = String.valueOf(pattern) + ".{" + this.plugin.getConfig().getInt("password.min-length") + ",})";
        Pattern p = Pattern.compile(pattern);
        Matcher matcher = p.matcher(pass);
        return matcher.matches();
    }

    private boolean isValidEmail(String email) {
        if (!this.plugin.getConfig().getBoolean("registration.validate-email")) {
            return true;
        }
        return EmailValidatorFactory.EMAIL.isValid((Object)email);
    }
}

