/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.auth;

import com.cypherx.xauth.auth.Auth;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class AuthURL
extends Auth {
    private static final int version = 1;
    private String ipAddress = null;

    public AuthURL(xAuth plugin) {
        this(plugin, null);
    }

    public AuthURL(xAuth plugin, String ipAddress) {
        this.plugin = plugin;
        this.ipAddress = ipAddress;
    }

    public boolean login(String user, String pass) {
        return this.checkAuthURL("login", "user", user, "pass", pass);
    }

    public boolean register(String user, String pass, String email) {
        if (!this.plugin.getConfig().getBoolean("authurl.registration")) {
            this.response = "authurl.registration";
            return false;
        }
        return this.checkAuthURL("register", "user", user, "pass", pass, "email", email);
    }

    public boolean adminRegister(String user, String pass, String email) {
        return false;
    }

    public boolean changePassword(String user, String oldPass, String newPass) {
        this.response = "authurl.changepw";
        return false;
    }

    public boolean adminChangePassword(String user, String newPass) {
        this.response = "authurl.changepw";
        return false;
    }

    public boolean online(String user) {
        if (!this.plugin.getConfig().getBoolean("authurl.status")) {
            return false;
        }
        return this.checkAuthURL("online", "user", user);
    }

    public boolean offline(String user) {
        if (!this.plugin.getConfig().getBoolean("authurl.status")) {
            return false;
        }
        return this.checkAuthURL("offline", "user", user);
    }

    private void writeParam(DataOutputStream out, String name, String value) throws Exception {
        if (value == null) {
            return;
        }
        String param = "&" + name + "=" + URLEncoder.encode(value, "UTF-8");
        out.writeBytes(param);
    }

    private boolean checkAuthURL(String action, String ... params) {
        if (params.length < 2 || params.length % 2 != 0) {
            return false;
        }
        try {
            HttpURLConnection uc = (HttpURLConnection)new URL(this.plugin.getConfig().getString("authurl.url")).openConnection();
            uc.setRequestMethod("POST");
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            uc.setAllowUserInteraction(false);
            uc.setInstanceFollowRedirects(false);
            uc.setRequestProperty("User-Agent", "Mozilla/5.0 authURL/1");
            uc.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            DataOutputStream out = new DataOutputStream(uc.getOutputStream());
            out.writeBytes("authurl_version=1");
            this.writeParam(out, "ip", this.ipAddress);
            this.writeParam(out, "action", action);
            int x = 0;
            while (x < params.length) {
                this.writeParam(out, params[x], params[++x]);
                ++x;
            }
            out.flush();
            out.close();
            BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            String line = in.readLine();
            boolean success = line != null && line.equals("YES");
            this.response = in.readLine();
            if (this.plugin.getConfig().getBoolean("authurl.groups")) {
                this.group = in.readLine();
            }
            in.close();
            return success;
        }
        catch (Exception e) {
            xAuthLog.severe("Failed to process AuthURL script during action: " + action, e);
            return false;
        }
    }
}

