/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.commands;

import com.cypherx.xauth.auth.Auth;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import com.cypherx.xauth.xAuthPlayer;
import com.martiansoftware.jsap.CommandLineTokenizer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LoginCommand
implements CommandExecutor {
    private final xAuth plugin;

    public LoginCommand(xAuth plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        args = CommandLineTokenizer.tokenize(args);
        if (sender instanceof Player) {
            xAuthPlayer p = this.plugin.getPlyrMngr().getPlayer((Player)sender);
            if (args.length < 1) {
                this.plugin.getMsgHndlr().sendMessage("login.usage", (CommandSender)p.getPlayer());
                return true;
            }
            String playerName = p.getPlayerName();
            String password = args[0];
            Auth a = this.plugin.getAuthClass(p);
            boolean passChecks = a.login(playerName, password);
            String response = a.getResponse();
            if (passChecks) {
                boolean success = this.plugin.getPlyrMngr().doLogin(p);
                if (success) {
                    if (this.plugin.isAuthURL() && this.plugin.getConfig().getBoolean("authurl.broadcast-login") && response != null && response != "") {
                        this.plugin.getServer().broadcastMessage(response);
                    }
                    response = "login.success";
                    a.online(p.getPlayerName());
                    xAuthLog.info(String.valueOf(playerName) + " has logged in");
                } else {
                    response = "login.error.general";
                }
            }
            if (response != null) {
                this.plugin.getMsgHndlr().sendMessage(response, (CommandSender)p.getPlayer());
            }
            return true;
        }
        return false;
    }
}

