/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.commands;

import com.cypherx.xauth.auth.Auth;
import com.cypherx.xauth.plugins.xPermissions;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import com.cypherx.xauth.xAuthPlayer;
import com.martiansoftware.jsap.CommandLineTokenizer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.entity.Player;

public class xAuthCommand
implements CommandExecutor {
    private final xAuth plugin;

    public xAuthCommand(xAuth plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player || sender instanceof ConsoleCommandSender || sender instanceof RemoteConsoleCommandSender) {
            if (args.length < 1) {
                return false;
            }
            String subCommand = (args = CommandLineTokenizer.tokenize(args))[0];
            if (subCommand.equals("register")) {
                return this.registerCommand(sender, args);
            }
            if (subCommand.equals("changepw") || subCommand.equals("cpw") || subCommand.equals("changepassword") || subCommand.equals("changepass")) {
                return this.changePwCommand(sender, args);
            }
            if (subCommand.equals("logout")) {
                return this.logoutCommand(sender, args);
            }
            if (subCommand.equals("unregister") || subCommand.equals("unreg")) {
                return this.unregisterCommand(sender, args);
            }
            if (subCommand.equals("location") || subCommand.equals("loc")) {
                return this.locationCommand(sender, args);
            }
            if (subCommand.equals("reload")) {
                return this.reloadCommand(sender, args);
            }
            if (subCommand.equals("activate")) {
                return this.activateCommand(sender, args);
            }
            if (subCommand.equals("config") || subCommand.equals("conf")) {
                return this.configCommand(sender, args);
            }
            if (subCommand.equals("profile") || subCommand.equals("info")) {
                return this.profileCommand(sender, args);
            }
            return true;
        }
        return false;
    }

    private boolean registerCommand(CommandSender sender, String[] args) {
        if (!xPermissions.has(sender, "xauth.admin.register")) {
            this.plugin.getMsgHndlr().sendMessage("admin.permission", sender);
            return true;
        }
        if (args.length < 3) {
            this.plugin.getMsgHndlr().sendMessage("admin.register.usage", sender);
            return true;
        }
        String targetName = args[1];
        String password = args[2];
        String email = args.length > 3 ? args[3] : null;
        xAuthPlayer xp = this.plugin.getPlyrMngr().getPlayer(targetName);
        Auth a = this.plugin.getAuthClass(xp);
        boolean success = a.adminRegister(targetName, password, email);
        String response = a.getResponse();
        if (response != null) {
            this.plugin.getMsgHndlr().sendMessage(response, sender, targetName);
        }
        if (success) {
            xAuthLog.info(String.valueOf(sender.getName()) + " has registered an account for " + targetName);
        }
        return true;
    }

    private boolean changePwCommand(CommandSender sender, String[] args) {
        if (!xPermissions.has(sender, "xauth.admin.changepw")) {
            this.plugin.getMsgHndlr().sendMessage("admin.permission", sender);
            return true;
        }
        if (args.length < 3) {
            this.plugin.getMsgHndlr().sendMessage("admin.changepw.usage", sender);
            return true;
        }
        String targetName = args[1];
        String newPassword = args[2];
        xAuthPlayer xp = this.plugin.getPlyrMngr().getPlayer(targetName);
        Auth a = this.plugin.getAuthClass(xp);
        boolean success = a.adminChangePassword(targetName, newPassword);
        String response = a.getResponse();
        if (response != null) {
            this.plugin.getMsgHndlr().sendMessage(response, sender, targetName);
        }
        if (success) {
            xAuthLog.info(String.valueOf(sender.getName()) + " changed " + targetName + "'s password");
        }
        return true;
    }

    private boolean logoutCommand(CommandSender sender, String[] args) {
        if (!xPermissions.has(sender, "xauth.admin.logout")) {
            this.plugin.getMsgHndlr().sendMessage("admin.permission", sender);
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMsgHndlr().sendMessage("admin.logout.usage", sender);
            return true;
        }
        String targetName = args[1];
        xAuthPlayer xp = this.plugin.getPlyrMngr().getPlayer(targetName);
        if (!xp.isAuthenticated()) {
            this.plugin.getMsgHndlr().sendMessage("admin.logout.error.logged", sender, targetName);
            return true;
        }
        boolean success = this.plugin.getPlyrMngr().deleteSession(xp.getAccountId());
        if (success) {
            xp.setStatus(xAuthPlayer.Status.Registered);
            this.plugin.getAuthClass(xp).offline(xp.getPlayerName());
            this.plugin.getMsgHndlr().sendMessage("admin.logout.success.player", sender, targetName);
            Player target = xp.getPlayer();
            if (target != null) {
                this.plugin.getPlyrMngr().protect(xp);
                this.plugin.getMsgHndlr().sendMessage("admin.logout.success.target", (CommandSender)target);
            }
        } else {
            this.plugin.getMsgHndlr().sendMessage("admin.logout.error.general", sender);
        }
        return true;
    }

    private boolean unregisterCommand(CommandSender sender, String[] args) {
        if (!xPermissions.has(sender, "xauth.admin.unregister")) {
            this.plugin.getMsgHndlr().sendMessage("admin.permission", sender);
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMsgHndlr().sendMessage("admin.unregister.usage", sender);
            return true;
        }
        String targetName = args[1];
        xAuthPlayer xp = this.plugin.getPlyrMngr().getPlayer(targetName);
        if (!xp.isRegistered()) {
            this.plugin.getMsgHndlr().sendMessage("admin.unregister.error.registered", sender, targetName);
            return true;
        }
        boolean success = this.plugin.getPlyrMngr().deleteAccount(xp.getAccountId());
        if (success) {
            xp.setStatus(xAuthPlayer.Status.Guest);
            this.plugin.getAuthClass(xp).offline(xp.getPlayerName());
            this.plugin.getMsgHndlr().sendMessage("admin.unregister.success.player", sender, targetName);
            Player target = xp.getPlayer();
            if (target != null) {
                this.plugin.getPlyrMngr().protect(xp);
                this.plugin.getMsgHndlr().sendMessage("admin.unregister.success.target", (CommandSender)target);
            }
        } else {
            this.plugin.getMsgHndlr().sendMessage("admin.unregister.error.general", sender);
        }
        return true;
    }

    private boolean locationCommand(CommandSender sender, String[] args) {
        String response;
        boolean global;
        if (sender instanceof ConsoleCommandSender) {
            xAuthLog.info("This command cannot be executed from the console!");
            return true;
        }
        Player player = (Player)sender;
        if (!xPermissions.has((CommandSender)player, "xauth.admin.location")) {
            this.plugin.getMsgHndlr().sendMessage("admin.permission", (CommandSender)player);
            return true;
        }
        if (args.length < 2 || !args[1].equals("set") && !args[1].equals("remove")) {
            this.plugin.getMsgHndlr().sendMessage("admin.location.usage", (CommandSender)player);
            return true;
        }
        String action = args[1];
        boolean bl = global = args.length > 2 && args[2].equals("global");
        if (action.equals("set")) {
            if (!global && player.getWorld().getUID().equals(this.plugin.getLocMngr().getGlobalUID())) {
                this.plugin.getMsgHndlr().sendMessage("admin.location.set.error.global", (CommandSender)player);
                return true;
            }
            boolean success = this.plugin.getLocMngr().setLocation(player.getLocation(), global);
            response = success ? "admin.location.set.success." + (global ? "global" : "regular") : "admin.location.set.error.general";
        } else {
            boolean success;
            if (global) {
                if (this.plugin.getLocMngr().getGlobalUID() == null) {
                    this.plugin.getMsgHndlr().sendMessage("admin.location.remove.error.noglobal", (CommandSender)player);
                    return true;
                }
            } else {
                if (!this.plugin.getLocMngr().isLocationSet(player.getWorld())) {
                    this.plugin.getMsgHndlr().sendMessage("admin.location.remove.error.notset", (CommandSender)player);
                    return true;
                }
                if (player.getWorld().getUID().equals(this.plugin.getLocMngr().getGlobalUID())) {
                    this.plugin.getMsgHndlr().sendMessage("admin.location.remove.error.global", (CommandSender)player);
                    return true;
                }
            }
            response = (success = this.plugin.getLocMngr().removeLocation(player.getWorld())) ? "admin.location.remove.success." + (global ? "global" : "regular") : "admin.location.remove.error.general";
        }
        this.plugin.getMsgHndlr().sendMessage(response, (CommandSender)player);
        return true;
    }

    private boolean reloadCommand(CommandSender sender, String[] args) {
        if (!xPermissions.has(sender, "xauth.admin.reload")) {
            this.plugin.getMsgHndlr().sendMessage("admin.permission", sender);
            return true;
        }
        this.plugin.reload();
        this.plugin.getMsgHndlr().sendMessage("admin.reload", sender);
        return true;
    }

    private boolean activateCommand(CommandSender sender, String[] args) {
        if (!xPermissions.has(sender, "xauth.admin.activate")) {
            this.plugin.getMsgHndlr().sendMessage("admin.permission", sender);
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMsgHndlr().sendMessage("admin.activate.usage", sender);
            return true;
        }
        String targetName = args[1];
        xAuthPlayer xp = this.plugin.getPlyrMngr().getPlayer(targetName);
        if (!xp.isRegistered()) {
            this.plugin.getMsgHndlr().sendMessage("admin.activate.error.registered", sender);
            return true;
        }
        if (this.plugin.getPlyrMngr().isActive(xp.getAccountId())) {
            this.plugin.getMsgHndlr().sendMessage("admin.activate.error.active", sender);
            return true;
        }
        boolean success = this.plugin.getPlyrMngr().activateAcc(xp.getAccountId());
        this.plugin.getMsgHndlr().sendMessage(success ? "admin.activate.success" : "admin.activate.error.general", sender, targetName);
        return true;
    }

    private boolean configCommand(CommandSender sender, String[] args) {
        block9: {
            if (!xPermissions.has(sender, "xauth.admin.config")) {
                this.plugin.getMsgHndlr().sendMessage("admin.permission", sender);
                return true;
            }
            if (args.length < 3) {
                this.plugin.getMsgHndlr().sendMessage("admin.config.usage", sender);
                return true;
            }
            String node = args[1];
            Object defVal = this.plugin.getConfig().getDefaults().get(node);
            if (defVal == null) {
                this.plugin.getMsgHndlr().sendMessage("admin.config.error.exist", sender);
                return true;
            }
            String value = args[2];
            try {
                if (defVal instanceof String) {
                    this.plugin.getConfig().set(node, (Object)value);
                    break block9;
                }
                if (defVal instanceof Integer) {
                    this.plugin.getConfig().set(node, (Object)Integer.parseInt(value));
                    break block9;
                }
                if (defVal instanceof Boolean) {
                    this.plugin.getConfig().set(node, (Object)Boolean.parseBoolean(value));
                    break block9;
                }
                throw new IllegalArgumentException();
            }
            catch (NumberFormatException e) {
                this.plugin.getMsgHndlr().sendMessage("admin.config.error.int", sender);
                return true;
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMsgHndlr().sendMessage("admin.config.error.invalid", sender);
                return true;
            }
        }
        this.plugin.saveConfig();
        this.plugin.getMsgHndlr().sendMessage("admin.config.success", sender);
        return true;
    }

    private boolean profileCommand(CommandSender sender, String[] args) {
        if (!xPermissions.has(sender, "xauth.admin.profile")) {
            this.plugin.getMsgHndlr().sendMessage("admin.permission", sender);
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMsgHndlr().sendMessage("admin.profile.usage", sender);
            return true;
        }
        String targetName = args[1];
        xAuthPlayer xp = this.plugin.getPlyrMngr().getPlayer(targetName);
        StringBuilder sb = new StringBuilder("------ xAuth Profile ------");
        sb.append("Player: ").append(xp.getPlayerName()).append("\tTest");
        if (xp.isAuthenticated()) {
            sb.append("This player is registered and logged in.");
        } else if (xp.isRegistered()) {
            sb.append("This player is registered but not logged in.");
        }
        return true;
    }
}

