/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.database;

import com.cypherx.xauth.database.ConnectionPool;
import com.cypherx.xauth.database.DatabaseUpdater;
import com.cypherx.xauth.database.Table;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseController {
    private final xAuth plugin;
    private ConnectionPool connPool;
    private List<Table> activeTables = new ArrayList<Table>();
    private DBMS dbms = DBMS.H2;

    public DatabaseController(xAuth plugin) {
        this.plugin = plugin;
        this.dbInit();
    }

    private void dbInit() {
        String pass;
        String user;
        String url;
        String driver;
        if (this.plugin.getConfig().getBoolean("mysql.enabled")) {
            this.dbms = DBMS.MySQL;
            ConfigurationSection cs = this.plugin.getConfig().getConfigurationSection("mysql");
            String host = cs.getString("host");
            int port = cs.getInt("port");
            String db = cs.getString("database");
            driver = "com.mysql.jdbc.Driver";
            url = "jdbc:mysql://" + host + ":" + port + "/" + db + "?zeroDateTimeBehavior=convertToNull";
            user = cs.getString("user");
            pass = cs.getString("password");
        } else {
            driver = "org.h2.Driver";
            url = "jdbc:h2:" + this.plugin.getDataFolder() + File.separator + "xAuth;MODE=MySQL;IGNORECASE=TRUE";
            user = "sa";
            pass = "";
        }
        try {
            this.connPool = new ConnectionPool(driver, url, user, pass);
        }
        catch (ClassNotFoundException e) {
            xAuthLog.severe("Failed to create instance of " + this.getDBMS() + " JDBC Driver!", e);
        }
        this.activeTables.add(Table.ACCOUNT);
        this.activeTables.add(Table.PLAYERDATA);
        if (this.plugin.getConfig().getInt("session.length") > 0) {
            this.activeTables.add(Table.SESSION);
        }
        if (this.plugin.getConfig().getBoolean("guest.protect-location")) {
            this.activeTables.add(Table.LOCATION);
        }
        if (this.plugin.getConfig().getInt("strikes.lockout-length") > 0) {
            this.activeTables.add(Table.LOCKOUT);
        }
    }

    public boolean isConnectable() {
        Connection conn = null;
        try {
            conn = this.getConnection();
            boolean bl = conn != null && !conn.isClosed();
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
        finally {
            this.close(conn);
        }
    }

    public Connection getConnection() {
        try {
            return this.connPool.leaseConn();
        }
        catch (Exception e) {
            xAuthLog.severe("Failed to borrow " + this.getDBMS() + " connection from pool!", e);
            return null;
        }
    }

    public void close(Connection conn, PreparedStatement ps) {
        this.close(conn, ps, null);
    }

    public void close(Connection conn, PreparedStatement ps, ResultSet rs) {
        this.close(rs);
        this.close(ps);
        this.close(conn);
    }

    public void close(Connection conn) {
        if (conn != null) {
            try {
                conn.setAutoCommit(true);
                this.connPool.returnConn(conn);
            }
            catch (Exception e) {
                xAuthLog.warning("Failed to return connection to pool!", e);
            }
        }
    }

    public void close(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                xAuthLog.warning("Failed to close PreparedStatement object!", e);
            }
        }
    }

    private void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                xAuthLog.warning("Failed to close ResultSet object!", e);
            }
        }
    }

    public void close() {
        try {
            this.connPool.close();
        }
        catch (Exception e) {
            xAuthLog.severe("Failed to close " + this.getDBMS() + " connection pool!", e);
        }
    }

    public void runUpdater() {
        DatabaseUpdater dbUpdater = new DatabaseUpdater(this.plugin, this);
        dbUpdater.runUpdate();
    }

    public boolean isTableActive(Table tbl) {
        return this.activeTables.contains((Object)tbl);
    }

    public String getTable(Table tbl) {
        if (this.dbms == DBMS.H2) {
            return tbl.getName();
        }
        return this.plugin.getConfig().getString("mysql.tables." + tbl.toString().toLowerCase());
    }

    public List<Table> getActiveTables() {
        return this.activeTables;
    }

    public String getDBMS() {
        return this.dbms.toString();
    }

    public boolean isMySQL() {
        return this.dbms == DBMS.MySQL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DBMS {
        H2,
        MySQL;

    }
}

