/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.password;

import com.cypherx.xauth.database.Table;
import com.cypherx.xauth.password.PasswordType;
import com.cypherx.xauth.password.Whirlpool;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;

public class PasswordHandler {
    private final xAuth plugin;

    public PasswordHandler(xAuth plugin) {
        this.plugin = plugin;
    }

    public boolean checkPassword(int accountId, String checkPass) {
        ResultSet rs;
        PreparedStatement ps;
        Connection conn;
        PasswordType type;
        String realPass;
        block17: {
            realPass = "";
            type = PasswordType.DEFAULT;
            conn = this.plugin.getDbCtrl().getConnection();
            ps = null;
            rs = null;
            String sql = String.format("SELECT `password`, `pwtype` FROM `%s` WHERE `id` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
            ps = conn.prepareStatement(sql);
            ps.setInt(1, accountId);
            rs = ps.executeQuery();
            if (rs.next()) break block17;
            this.plugin.getDbCtrl().close(conn, ps, rs);
            return false;
        }
        try {
            try {
                realPass = rs.getString("password");
                type = PasswordType.getType(rs.getInt("pwtype"));
            }
            catch (SQLException e) {
                xAuthLog.severe("Failed to retrieve password hash for account: " + accountId, e);
                this.plugin.getDbCtrl().close(conn, ps, rs);
                return false;
            }
        }
        catch (Throwable throwable) {
            this.plugin.getDbCtrl().close(conn, ps, rs);
            throw throwable;
        }
        this.plugin.getDbCtrl().close(conn, ps, rs);
        String checkPassHash = "";
        if (type == PasswordType.DEFAULT) {
            int saltPos = checkPass.length() >= realPass.length() ? realPass.length() - 1 : checkPass.length();
            String salt = realPass.substring(saltPos, saltPos + 12);
            String hash = this.whirlpool(String.valueOf(salt) + checkPass);
            checkPassHash = String.valueOf(hash.substring(0, saltPos)) + salt + hash.substring(saltPos);
        } else if (type == PasswordType.WHIRLPOOL) {
            checkPassHash = this.whirlpool(checkPass);
        } else if (type == PasswordType.AUTHME_SHA256) {
            String salt = realPass.split("\\$")[2];
            checkPassHash = "$SHA$" + salt + "$" + this.hash(String.valueOf(this.hash(checkPass, "SHA-256")) + salt, "SHA-256");
        } else {
            checkPassHash = this.hash(checkPass, type.getAlgorithm());
        }
        if (checkPassHash.equals(realPass)) {
            String newHash = this.hash(checkPass);
            conn = this.plugin.getDbCtrl().getConnection();
            try {
                try {
                    String sql = String.format("UPDATE `%s` SET `password` = ?, `pwtype` = ? WHERE `id` = ?", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
                    ps = conn.prepareStatement(sql);
                    ps.setString(1, newHash);
                    ps.setInt(2, 0);
                    ps.setInt(3, accountId);
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    xAuthLog.severe("Failed to update password hash for account: " + accountId, e);
                    this.plugin.getDbCtrl().close(conn, ps);
                }
            }
            finally {
                this.plugin.getDbCtrl().close(conn, ps);
            }
            return true;
        }
        return false;
    }

    public String hash(String toHash) {
        String salt = this.whirlpool(UUID.randomUUID().toString()).substring(0, 12);
        String hash = this.whirlpool(String.valueOf(salt) + toHash);
        int saltPos = toHash.length() >= hash.length() ? hash.length() - 1 : toHash.length();
        return String.valueOf(hash.substring(0, saltPos)) + salt + hash.substring(saltPos);
    }

    private String hash(String toHash, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(toHash.getBytes());
            byte[] digest = md.digest();
            return String.format("%0" + (digest.length << 1) + "x", new BigInteger(1, digest));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String whirlpool(String toHash) {
        Whirlpool w = new Whirlpool();
        byte[] digest = new byte[64];
        w.NESSIEinit();
        w.NESSIEadd(toHash);
        w.NESSIEfinalize(digest);
        return Whirlpool.display(digest);
    }
}

