/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth;

import com.cypherx.xauth.LocationManager;
import com.cypherx.xauth.MessageHandler;
import com.cypherx.xauth.PlayerDataHandler;
import com.cypherx.xauth.PlayerManager;
import com.cypherx.xauth.Utils;
import com.cypherx.xauth.auth.Auth;
import com.cypherx.xauth.auth.AuthSQL;
import com.cypherx.xauth.auth.AuthURL;
import com.cypherx.xauth.commands.ChangePwdCommand;
import com.cypherx.xauth.commands.LoginCommand;
import com.cypherx.xauth.commands.LogoutCommand;
import com.cypherx.xauth.commands.RegisterCommand;
import com.cypherx.xauth.commands.xAuthCommand;
import com.cypherx.xauth.database.DatabaseController;
import com.cypherx.xauth.listeners.xAuthBlockListener;
import com.cypherx.xauth.listeners.xAuthEntityListener;
import com.cypherx.xauth.listeners.xAuthPlayerListener;
import com.cypherx.xauth.password.PasswordHandler;
import com.cypherx.xauth.plugins.xPermissions;
import com.cypherx.xauth.strike.StrikeManager;
import com.cypherx.xauth.updater.Updater;
import com.cypherx.xauth.xAuthLog;
import com.cypherx.xauth.xAuthPlayer;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class xAuth
extends JavaPlugin {
    private DatabaseController dbCtrl;
    private MessageHandler msgCtrl;
    private PlayerManager plyrMngr;
    private PlayerDataHandler plyrDtHndlr;
    private PasswordHandler pwdHndlr;
    private LocationManager locMngr;
    private StrikeManager strkMngr;
    private String h2Version = "1.3.164";

    public void onDisable() {
        if (this.dbCtrl != null) {
            Player[] playerArray = this.getServer().getOnlinePlayers();
            int n = playerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Player p = playerArray[n2];
                xAuthPlayer xp = this.plyrMngr.getPlayer(p);
                if (xp.isProtected()) {
                    this.plyrMngr.unprotect(xp);
                }
                ++n2;
            }
            this.dbCtrl.close();
        }
    }

    public void onEnable() {
        File h2File;
        Updater updater;
        this.getDataFolder().mkdirs();
        this.loadConfiguration();
        if (this.getConfig().getBoolean("main.auto-disable") && this.getServer().getOnlineMode()) {
            xAuthLog.info("Auto-disabling, server is running in online-mode");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.getConfig().getBoolean("main.check-for-updates") && (updater = new Updater(this.getDescription().getVersion())).isUpdateAvailable()) {
            updater.printMessage();
        }
        if (!(h2File = new File("lib", "h2-" + this.h2Version + ".jar")).exists() && this.getConfig().getBoolean("main.download-library") && !this.getConfig().getBoolean("mysql.enabled")) {
            xAuthLog.info("-------------------------------");
            xAuthLog.info("Downloading required H2 library..");
            this.downloadLib(h2File);
            xAuthLog.info("Download complete.");
            xAuthLog.info("");
            xAuthLog.info("Reload the server to enable xAuth.");
            xAuthLog.info("-------------------------------");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        xPermissions.init(this);
        this.dbCtrl = new DatabaseController(this);
        if (!this.dbCtrl.isConnectable()) {
            xAuthLog.severe("Failed to establish " + this.dbCtrl.getDBMS() + " database connection!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        xAuthLog.info("Successfully established connection to " + this.dbCtrl.getDBMS() + " database");
        this.dbCtrl.runUpdater();
        this.plyrMngr = new PlayerManager(this);
        this.plyrDtHndlr = new PlayerDataHandler(this);
        this.pwdHndlr = new PasswordHandler(this);
        this.locMngr = new LocationManager(this);
        this.strkMngr = new StrikeManager(this);
        Player[] players = this.getServer().getOnlinePlayers();
        if (players.length > 0) {
            this.plyrMngr.handleReload(players);
        }
        new xAuthPlayerListener(this);
        new xAuthBlockListener(this);
        new xAuthEntityListener(this);
        this.getCommand("register").setExecutor((CommandExecutor)new RegisterCommand(this));
        this.getCommand("login").setExecutor((CommandExecutor)new LoginCommand(this));
        this.getCommand("logout").setExecutor((CommandExecutor)new LogoutCommand(this));
        this.getCommand("changepw").setExecutor((CommandExecutor)new ChangePwdCommand(this));
        this.getCommand("xauth").setExecutor((CommandExecutor)new xAuthCommand(this));
        xAuthLog.info(String.format("v%s Enabled!", this.getDescription().getVersion()));
        this.lol();
    }

    private void loadConfiguration() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.msgCtrl = new MessageHandler(this);
        this.msgCtrl.getConfig().options().copyDefaults(true);
        this.msgCtrl.saveConfig();
        this.msgCtrl.reloadConfig();
    }

    private void downloadLib(File h2File) {
        File dir = new File("lib");
        if (!dir.exists()) {
            dir.mkdir();
        }
        Utils.downloadFile(h2File, "http://love-despite.com/cypher/bukkit/lib/" + h2File.getName());
    }

    public File getJar() {
        return this.getFile();
    }

    public DatabaseController getDbCtrl() {
        return this.dbCtrl;
    }

    public MessageHandler getMsgHndlr() {
        return this.msgCtrl;
    }

    public PlayerManager getPlyrMngr() {
        return this.plyrMngr;
    }

    public PlayerDataHandler getPlyrDtHndlr() {
        return this.plyrDtHndlr;
    }

    public PasswordHandler getPwdHndlr() {
        return this.pwdHndlr;
    }

    public LocationManager getLocMngr() {
        return this.locMngr;
    }

    public StrikeManager getStrkMngr() {
        return this.strkMngr;
    }

    public Auth getAuthClass(xAuthPlayer p) {
        if (this.isAuthURL()) {
            return new AuthURL(this, p.getIPAddress());
        }
        return new AuthSQL(this, p);
    }

    public boolean isAuthURL() {
        return this.getConfig().getBoolean("authurl.enabled");
    }

    public void reload() {
        this.loadConfiguration();
    }

    private void lol() {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getDefault());
        int month = cal.get(2);
        int day = cal.get(5);
        if (month == 3 && day == 1) {
            xAuthLog.warning("Your trial version of xAuth expires today!");
            xAuthLog.warning("Purchase the full version on Steam for $19.99.");
        } else if (month == 3 && day == 2) {
            xAuthLog.info("April Fools!! xAuth will always be free!");
        }
    }
}

