/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ConnectionPool {
    private static final int maxConnections = 10;
    private String url;
    private String user;
    private String password;
    private Vector<Connection> idleConnections = new Vector();
    private Vector<Connection> busyConnections = new Vector();
    private Lock lock = new ReentrantLock();

    public ConnectionPool(String driver, String url, String user, String password) throws ClassNotFoundException {
        Class.forName(driver);
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public Connection leaseConn() throws SQLException {
        this.lock.lock();
        try {
            if (!this.idleConnections.isEmpty()) {
                Connection conn = this.idleConnections.firstElement();
                this.idleConnections.removeElementAt(0);
                if (conn.isValid(1)) {
                    this.busyConnections.add(conn);
                    Connection connection = conn;
                    return connection;
                }
                conn.close();
                Connection connection = this.leaseConn();
                return connection;
            }
            if (this.idleConnections.size() + this.busyConnections.size() >= 10) {
                throw new SQLException("Connection pool is full");
            }
            Connection conn = DriverManager.getConnection(this.url, this.user, this.password);
            if (conn.isValid(1)) {
                this.busyConnections.add(conn);
                Connection connection = conn;
                return connection;
            }
            conn.close();
            throw new SQLException("Failed to validate new connection");
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized void returnConn(Connection conn) {
        this.lock.lock();
        this.busyConnections.remove(conn);
        this.idleConnections.add(conn);
        this.lock.unlock();
    }

    public synchronized void close() throws SQLException {
        this.lock.lock();
        for (Connection conn : this.idleConnections) {
            conn.close();
        }
        for (Connection conn : this.busyConnections) {
            conn.close();
        }
        this.busyConnections.clear();
        this.idleConnections.clear();
        this.lock.unlock();
    }
}

