/*
 * Decompiled with CFR 0.152.
 */
package com.cypherx.xauth.database;

import com.cypherx.xauth.Utils;
import com.cypherx.xauth.database.DatabaseController;
import com.cypherx.xauth.database.Table;
import com.cypherx.xauth.database.TableUpdateException;
import com.cypherx.xauth.xAuth;
import com.cypherx.xauth.xAuthLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseUpdater {
    private final xAuth plugin;
    private final DatabaseController dbCon;
    private File dbVersionFile;
    private final Properties dbVersionProp = new Properties();

    public DatabaseUpdater(xAuth plugin, DatabaseController dbCon) {
        this.plugin = plugin;
        this.dbCon = dbCon;
        this.loadVersionFile();
    }

    private void loadVersionFile() {
        this.dbVersionFile = new File(this.plugin.getDataFolder(), "DBVERSION");
        try {
            if (!this.dbVersionFile.exists()) {
                this.dbVersionFile.createNewFile();
            }
            this.dbVersionProp.load(new FileInputStream(this.dbVersionFile));
        }
        catch (IOException e) {
            xAuthLog.severe("Failed to load database version file!");
        }
    }

    private void updateVersionFile(String tblId, int version) {
        this.dbVersionProp.setProperty(tblId, String.valueOf(version));
        try {
            this.dbVersionProp.store(new FileOutputStream(this.dbVersionFile), null);
        }
        catch (IOException e) {
            xAuthLog.severe("Failed to update database table version file!", e);
        }
    }

    public void runUpdate() {
        for (Table tbl : this.dbCon.getActiveTables()) {
            int currentVersion;
            String tblId;
            block20: {
                int updateVersion;
                List<String> updateFiles;
                String tblName;
                block19: {
                    tblId = tbl.toString().toLowerCase();
                    tblName = this.dbCon.getTable(tbl);
                    updateFiles = this.loadUpdateFiles(tblId);
                    currentVersion = Integer.parseInt(this.dbVersionProp.getProperty(tblId, "-1"));
                    if (currentVersion == -1) {
                        Connection conn = this.dbCon.getConnection();
                        try {
                            try {
                                String createSql = this.loadSQL("sql/" + tblId + "/table.sql", tblName);
                                this.executeQuery(createSql, conn);
                                xAuthLog.info("Table created: " + tblName);
                                currentVersion = 0;
                            }
                            catch (TableUpdateException e) {
                                xAuthLog.severe("Failed to create table: " + tblName, e);
                                this.dbCon.close(conn);
                                break block19;
                            }
                        }
                        catch (Throwable throwable) {
                            this.dbCon.close(conn);
                            throw throwable;
                        }
                        this.dbCon.close(conn);
                    }
                }
                if ((updateVersion = this.getLatestUpdateVersion(updateFiles)) > currentVersion && currentVersion > -1) {
                    Connection conn = this.dbCon.getConnection();
                    try {
                        conn.setAutoCommit(false);
                        for (String updateFile : updateFiles) {
                            String[] updateSql;
                            if (this.getUpdateVersion(updateFile) <= currentVersion) continue;
                            String[] stringArray = updateSql = this.loadSQL(updateFile, tblName).split(System.getProperty("line.separator"));
                            int n = updateSql.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String sql = stringArray[n2];
                                this.executeQuery(sql, conn);
                                ++n2;
                            }
                            conn.commit();
                            ++currentVersion;
                        }
                        xAuthLog.info(String.format("Table [%s] updated to revision [%s]", tblName, this.formatVersion(currentVersion)));
                    }
                    catch (TableUpdateException e) {
                        xAuthLog.severe(String.format("Something went wrong while updating table [%s] to revision [%s]", tblName, this.formatVersion(currentVersion + 1)), e);
                        try {
                            conn.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.dbCon.close(conn);
                        break block20;
                    }
                    catch (SQLException e) {
                        try {
                            e.printStackTrace();
                            break block20;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            this.dbCon.close(conn);
                        }
                    }
                    this.dbCon.close(conn);
                }
            }
            this.updateVersionFile(tblId, currentVersion);
        }
    }

    private List<String> loadUpdateFiles(String tblId) {
        ArrayList<String> updateFiles = new ArrayList<String>();
        String updatePath = "sql/" + tblId + "/updates/" + this.dbCon.getDBMS().toLowerCase();
        try {
            JarFile jar = new JarFile(this.plugin.getJar());
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String name = entries.nextElement().getName();
                if (!name.startsWith(updatePath) || !name.endsWith(".sql")) continue;
                updateFiles.add(name);
            }
        }
        catch (IOException e) {
            xAuthLog.severe("Failed to load update files for table: " + tblId, e);
        }
        return updateFiles;
    }

    private int getUpdateVersion(String filePath) {
        String fileName = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf("."));
        return Integer.parseInt(fileName.split("_")[0]);
    }

    private int getLatestUpdateVersion(List<String> updateFiles) {
        if (updateFiles.size() < 1) {
            return 0;
        }
        String filePath = updateFiles.get(updateFiles.size() - 1);
        return this.getUpdateVersion(filePath);
    }

    private String loadSQL(String path, String tblName) {
        String sql = Utils.streamToString(this.plugin.getResource(path));
        sql = sql.replace("{TABLE}", tblName);
        sql = sql.replace("{TABLE_ACCOUNT}", this.plugin.getDbCtrl().getTable(Table.ACCOUNT));
        return sql;
    }

    private void executeQuery(String query, Connection conn) throws TableUpdateException {
        if (query.length() > 0) {
            PreparedStatement ps = null;
            try {
                try {
                    ps = conn.prepareStatement(query);
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    throw new TableUpdateException(e.getMessage());
                }
            }
            finally {
                this.dbCon.close(ps);
            }
        }
    }

    private String formatVersion(int currentVersion) {
        String strCurVer = String.valueOf(currentVersion);
        if (strCurVer.length() == 1) {
            return "00" + strCurVer;
        }
        if (strCurVer.length() == 2) {
            return "0" + strCurVer;
        }
        return strCurVer;
    }
}

