/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.bukkit.migration.PermissionsResolverManager;
import com.sk89q.bukkit.migration.PermissionsResolverServerListener;
import com.sk89q.craftbook.CircuitsConfiguration;
import com.sk89q.craftbook.MechanicManager;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.MechanicClock;
import com.sk89q.craftbook.bukkit.MechanicListenerAdapter;
import com.sk89q.craftbook.circuits.GlowStone;
import com.sk89q.craftbook.circuits.JackOLantern;
import com.sk89q.craftbook.circuits.Netherrack;
import com.sk89q.craftbook.gates.logic.AndGate;
import com.sk89q.craftbook.gates.logic.Clock;
import com.sk89q.craftbook.gates.logic.DownCounter;
import com.sk89q.craftbook.gates.logic.EdgeTriggerDFlipFlop;
import com.sk89q.craftbook.gates.logic.InvertedRsNandLatch;
import com.sk89q.craftbook.gates.logic.Inverter;
import com.sk89q.craftbook.gates.logic.JkFlipFlop;
import com.sk89q.craftbook.gates.logic.LevelTriggeredDFlipFlop;
import com.sk89q.craftbook.gates.logic.Marquee;
import com.sk89q.craftbook.gates.logic.Monostable;
import com.sk89q.craftbook.gates.logic.Multiplexer;
import com.sk89q.craftbook.gates.logic.NandGate;
import com.sk89q.craftbook.gates.logic.RandomBit;
import com.sk89q.craftbook.gates.logic.Repeater;
import com.sk89q.craftbook.gates.logic.RsNandLatch;
import com.sk89q.craftbook.gates.logic.RsNorFlipFlop;
import com.sk89q.craftbook.gates.logic.ToggleFlipFlop;
import com.sk89q.craftbook.gates.logic.XnorGate;
import com.sk89q.craftbook.gates.logic.XorGate;
import com.sk89q.craftbook.gates.world.CreatureSpawner;
import com.sk89q.craftbook.gates.world.DaySensor;
import com.sk89q.craftbook.gates.world.DaySensorST;
import com.sk89q.craftbook.gates.world.FlexibleSetBlock;
import com.sk89q.craftbook.gates.world.ItemDispenser;
import com.sk89q.craftbook.gates.world.LavaSensor;
import com.sk89q.craftbook.gates.world.LavaSensorST;
import com.sk89q.craftbook.gates.world.LightSensor;
import com.sk89q.craftbook.gates.world.LightningSummon;
import com.sk89q.craftbook.gates.world.MessageSender;
import com.sk89q.craftbook.gates.world.MultipleSetBlock;
import com.sk89q.craftbook.gates.world.ResurrectDumbledore;
import com.sk89q.craftbook.gates.world.ServerTimeModulus;
import com.sk89q.craftbook.gates.world.TimeControl;
import com.sk89q.craftbook.gates.world.WaterSensor;
import com.sk89q.craftbook.gates.world.WaterSensorST;
import com.sk89q.craftbook.gates.world.WirelessReceiver;
import com.sk89q.craftbook.gates.world.WirelessReceiverST;
import com.sk89q.craftbook.gates.world.WirelessTransmitter;
import com.sk89q.craftbook.ic.ICManager;
import com.sk89q.craftbook.ic.ICMechanicFactory;
import com.sk89q.craftbook.ic.families.Family3ISO;
import com.sk89q.craftbook.ic.families.FamilySI3O;
import com.sk89q.craftbook.ic.families.FamilySISO;
import org.bukkit.Chunk;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class CircuitsPlugin
extends BaseBukkitPlugin {
    protected CircuitsConfiguration config;
    protected ICManager icManager;
    private PermissionsResolverManager perms;
    private MechanicManager manager;

    public void onEnable() {
        super.onEnable();
        Server server = this.getServer();
        this.createDefaultConfiguration("config.yml");
        this.createDefaultConfiguration("custom-ics.txt");
        this.config = new CircuitsConfiguration(this.getConfiguration(), this.getDataFolder());
        this.perms = new PermissionsResolverManager(this.getConfiguration(), server, this.getDescription().getName(), logger);
        new PermissionsResolverServerListener(this.perms).register((Plugin)this);
        this.manager = new MechanicManager(this);
        MechanicListenerAdapter adapter = new MechanicListenerAdapter(this);
        adapter.register(this.manager);
        this.registerICs();
        if (this.config.enableNetherstone) {
            this.manager.register(new Netherrack.Factory());
        }
        if (this.config.enablePumpkins) {
            this.manager.register(new JackOLantern.Factory());
        }
        if (this.config.enableGlowStone) {
            this.manager.register(new GlowStone.Factory());
        }
        if (this.config.enableICs) {
            this.manager.register(new ICMechanicFactory(this, this.icManager));
            this.setupSelfTriggered();
        }
    }

    private void registerICs() {
        Server server = this.getServer();
        this.icManager = new ICManager();
        FamilySISO familySISO = new FamilySISO();
        Family3ISO family3ISO = new Family3ISO();
        FamilySI3O familySI3O = new FamilySI3O();
        this.icManager.register("MC9999", new ResurrectDumbledore.Factory(server, true), familySISO);
        this.icManager.register("MC1000", new Repeater.Factory(server), familySISO);
        this.icManager.register("MC1001", new Inverter.Factory(server), familySISO);
        this.icManager.register("MC1017", new ToggleFlipFlop.Factory(server, true), familySISO);
        this.icManager.register("MC1018", new ToggleFlipFlop.Factory(server, false), familySISO);
        this.icManager.register("MC1020", new RandomBit.Factory(server, true), familySISO);
        this.icManager.register("MC1025", new ServerTimeModulus.Factory(server, true), familySISO);
        this.icManager.register("MC1110", new WirelessTransmitter.Factory(server), familySISO);
        this.icManager.register("MC1111", new WirelessReceiver.Factory(server, true), familySISO);
        this.icManager.register("MC1200", new CreatureSpawner.Factory(server, true), familySISO);
        this.icManager.register("MC1201", new ItemDispenser.Factory(server, true), familySISO);
        this.icManager.register("MC1207", new FlexibleSetBlock.Factory(server), familySISO);
        this.icManager.register("MC1208", new MultipleSetBlock.Factory(server), familySISO);
        this.icManager.register("MC1203", new LightningSummon.Factory(server, true), familySISO);
        this.icManager.register("MC1230", new DaySensor.Factory(server, true), familySISO);
        this.icManager.register("MC1231", new TimeControl.Factory(server, true), familySISO);
        this.icManager.register("MC1260", new WaterSensor.Factory(server, true), familySISO);
        this.icManager.register("MC1261", new LavaSensor.Factory(server, true), familySISO);
        this.icManager.register("MC1262", new LightSensor.Factory(server, true), familySISO);
        this.icManager.register("MC1510", new MessageSender.Factory(server, true), familySISO);
        this.icManager.register("MC2999", new Marquee.Factory(server), familySI3O);
        this.icManager.register("MC3002", new AndGate.Factory(server), family3ISO);
        this.icManager.register("MC3003", new NandGate.Factory(server), family3ISO);
        this.icManager.register("MC3020", new XorGate.Factory(server), family3ISO);
        this.icManager.register("MC3021", new XnorGate.Factory(server), family3ISO);
        this.icManager.register("MC3030", new RsNorFlipFlop.Factory(server), family3ISO);
        this.icManager.register("MC3031", new InvertedRsNandLatch.Factory(server), family3ISO);
        this.icManager.register("MC3032", new JkFlipFlop.Factory(server), family3ISO);
        this.icManager.register("MC3033", new RsNandLatch.Factory(server), family3ISO);
        this.icManager.register("MC3034", new EdgeTriggerDFlipFlop.Factory(server), family3ISO);
        this.icManager.register("MC3036", new LevelTriggeredDFlipFlop.Factory(server), family3ISO);
        this.icManager.register("MC3040", new Multiplexer.Factory(server), family3ISO);
        this.icManager.register("MC3101", new DownCounter.Factory(server), family3ISO);
        this.icManager.register("MC0111", new WirelessReceiverST.Factory(server), familySISO);
        this.icManager.register("MC0230", new DaySensorST.Factory(server), familySISO);
        this.icManager.register("MC0260", new WaterSensorST.Factory(server), familySISO);
        this.icManager.register("MC0261", new LavaSensorST.Factory(server), familySISO);
        this.icManager.register("MC0420", new Clock.Factory(server), familySISO);
        this.icManager.register("MC0421", new Monostable.Factory(server), familySISO);
    }

    private void setupSelfTriggered() {
        logger.info("CraftBook: Enumerating chunks for self-triggered components...");
        long start = System.currentTimeMillis();
        int numWorlds = 0;
        int numChunks = 0;
        for (World world : this.getServer().getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                this.manager.enumerate(chunk);
                ++numChunks;
            }
            ++numWorlds;
        }
        long time = System.currentTimeMillis() - start;
        logger.info("CraftBook: " + numChunks + " chunk(s) for " + numWorlds + " world(s) processed " + "(" + Math.round((double)time / 1000.0 * 10.0) / 10L + "s elapsed)");
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, (Runnable)new MechanicClock(this.manager), 0L, 2L);
    }

    protected void registerEvents() {
    }

    public CircuitsConfiguration getLocalConfiguration() {
        return this.config;
    }

    public PermissionsResolverManager getPermissionsResolver() {
        return this.perms;
    }
}

