/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class DownCounter
extends AbstractIC {
    public DownCounter(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Counter";
    }

    public String getSignTitle() {
        return "DOWN COUNTER";
    }

    public String validateEnvironment(Sign sign) {
        String id = this.getSign().getLines()[2];
        if (id == null || !id.matches("^[0-9]+:(INF|ONCE)$")) {
            return "Specify counter configuration on line 3.";
        }
        this.getSign().getLines()[3] = "0";
        return null;
    }

    public void trigger(ChipState chip) {
        String line3 = this.getSign().getLines()[2];
        String[] config = line3.split(":");
        int resetVal = Integer.parseInt(config[0]);
        boolean inf = config[1].equals("INF");
        String line4 = this.getSign().getLines()[3];
        int curVal = 0;
        try {
            curVal = Integer.parseInt(line4);
        }
        catch (Exception e) {
            curVal = resetVal;
        }
        int oldVal = curVal;
        if (chip.isTriggered(0) && chip.get(0)) {
            if (curVal == 0) {
                if (inf) {
                    curVal = resetVal;
                }
            } else {
                --curVal;
            }
            chip.set(3, curVal == 0);
        } else if (chip.isTriggered(1) && chip.get(1)) {
            curVal = resetVal;
        }
        if (curVal != oldVal) {
            this.getSign().setLine(3, Integer.toString(curVal));
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new DownCounter(this.getServer(), sign);
        }
    }
}

