/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class Monostable
extends AbstractIC
implements SelfTriggeredIC {
    Sign sign;

    public Monostable(Server server, Sign psign) {
        super(server, psign);
        this.sign = psign;
    }

    public String getTitle() {
        return "Monostable";
    }

    public String getSignTitle() {
        return "MONOSTABLE";
    }

    public void trigger(ChipState chip) {
        String setting = this.sign.getLine(2).toUpperCase();
        if (chip.getInput(0) && setting.contains("H") || !chip.getInput(0) && setting.contains("L")) {
            int index = setting.indexOf(":");
            if (index <= 0) {
                return;
            }
            chip.setOutput(0, true);
            this.sign.setLine(3, setting.substring(0, index));
        }
    }

    public void think(ChipState chip) {
        int tick;
        try {
            tick = Integer.parseInt(this.sign.getLine(3));
        }
        catch (NumberFormatException e) {
            tick = 0;
        }
        if (tick == 0) {
            chip.setOutput(0, false);
        } else {
            --tick;
        }
        this.sign.setLine(3, Integer.toString(tick));
    }

    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new Monostable(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            int ticks = -1;
            boolean hi = false;
            boolean lo = false;
            try {
                String set = sign.getLine(2).toUpperCase();
                if (set.indexOf(":") == -1) {
                    throw new ICVerificationException("Invalid syntax");
                }
                String[] settings = sign.getLine(2).split(":");
                if (settings.length != 2) {
                    throw new ICVerificationException("Invalid syntax");
                }
                ticks = Integer.parseInt(settings[0]);
                hi = settings[1].contains("H");
                lo = settings[1].contains("L");
                if (!hi && !lo) {
                    throw new ICVerificationException("Missing trigger levels");
                }
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("Invalid number format");
            }
            catch (ICVerificationException e) {
                throw e;
            }
            ticks = Math.max(ticks, 10);
            ticks = Math.min(ticks, 50);
            sign.setLine(2, Integer.toString(ticks) + ":" + (hi ? "H" : "") + (lo ? "L" : ""));
            sign.setLine(3, "0");
        }
    }
}

