/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class DaySensor
extends AbstractIC {
    protected boolean risingEdge;

    public DaySensor(Server server, Sign sign, boolean risingEdge) {
        super(server, sign);
        this.risingEdge = risingEdge;
    }

    public String getTitle() {
        return "Day Sensor";
    }

    public String getSignTitle() {
        return "DAY SENSOR";
    }

    public void trigger(ChipState chip) {
        if (this.risingEdge && chip.getInput(0) || !this.risingEdge && !chip.getInput(0)) {
            chip.setOutput(0, this.isDay());
        }
    }

    private boolean isDay() {
        long time = this.getSign().getBlock().getWorld().getTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time < 13000L;
    }

    public static class Factory
    extends AbstractICFactory {
        protected boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(Sign sign) {
            return new DaySensor(this.getServer(), sign, this.risingEdge);
        }
    }
}

