/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class LavaSensor
extends AbstractIC {
    protected boolean risingEdge;

    public LavaSensor(Server server, Sign sign, boolean risingEdge) {
        super(server, sign);
        this.risingEdge = risingEdge;
    }

    public String getTitle() {
        return "Lava Sensor";
    }

    public String getSignTitle() {
        return "LAVA SENSOR";
    }

    public void trigger(ChipState chip) {
        if (this.risingEdge && chip.getInput(0) || !this.risingEdge && !chip.getInput(0)) {
            chip.setOutput(0, this.hasWater());
        }
    }

    private boolean hasWater() {
        Block b = SignUtil.getBackBlock(this.getSign().getBlock());
        int x = b.getX();
        int yOffset = b.getY();
        int z = b.getZ();
        try {
            String yOffsetLine = this.getSign().getLine(2);
            yOffset = yOffsetLine.length() > 0 ? (yOffset += Integer.parseInt(yOffsetLine)) : --yOffset;
        }
        catch (NumberFormatException e) {
            --yOffset;
        }
        int blockID = this.getSign().getBlock().getWorld().getBlockTypeIdAt(x, yOffset, z);
        return blockID == 10 || blockID == 11;
    }

    public static class Factory
    extends AbstractICFactory {
        protected boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(Sign sign) {
            return new LavaSensor(this.getServer(), sign, this.risingEdge);
        }
    }
}

