/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class ServerTimeModulus
extends AbstractIC {
    protected boolean risingEdge;

    public ServerTimeModulus(Server server, Sign sign, boolean risingEdge) {
        super(server, sign);
        this.risingEdge = risingEdge;
    }

    public String getTitle() {
        return "Server Time Modulus";
    }

    public String getSignTitle() {
        return "SERVER TIME MOD";
    }

    public void trigger(ChipState chip) {
        if (this.risingEdge && chip.getInput(0) || !this.risingEdge && !chip.getInput(0)) {
            chip.setOutput(0, this.isServerTimeOdd());
        }
    }

    private boolean isServerTimeOdd() {
        long time = this.getSign().getBlock().getWorld().getTime() % 2L;
        if (time < 0L) {
            time += 2L;
        }
        return time == 1L;
    }

    public static class Factory
    extends AbstractICFactory {
        protected boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(Sign sign) {
            return new ServerTimeModulus(this.getServer(), sign, this.risingEdge);
        }
    }
}

