/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICManager;
import com.sk89q.craftbook.ic.ICMechanic;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RegisteredICFactory;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import com.sk89q.craftbook.ic.SelfTriggeredICMechanic;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICMechanicFactory
extends AbstractMechanicFactory<ICMechanic> {
    public static final Pattern codePattern = Pattern.compile("^\\[(MC[^\\]]+)\\]$", 2);
    protected ICManager manager;
    protected CircuitsPlugin plugin;

    public ICMechanicFactory(CircuitsPlugin plugin, ICManager manager) {
        this.plugin = plugin;
        this.manager = manager;
    }

    @Override
    public ICMechanic detect(BlockWorldVector pt) throws InvalidMechanismException {
        Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
        if (block.getTypeId() != 68) {
            return null;
        }
        Sign sign = (Sign)block.getState();
        Matcher matcher = codePattern.matcher(sign.getLine(1));
        if (!matcher.matches()) {
            return null;
        }
        String id = matcher.group(1);
        RegisteredICFactory registration = this.manager.get(id);
        if (registration == null) {
            throw new InvalidMechanismException("\"" + sign.getLine(1) + "\" should be an IC ID, but no IC registered under that ID could be found.");
        }
        IC ic = registration.getFactory().create(sign);
        if (ic instanceof SelfTriggeredIC) {
            return new SelfTriggeredICMechanic(this.plugin, id, (SelfTriggeredIC)ic, registration.getFamily(), pt);
        }
        return new ICMechanic(this.plugin, id, ic, registration.getFamily(), pt);
    }

    @Override
    public ICMechanic detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException {
        Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
        Matcher matcher = codePattern.matcher(sign.getLine(1));
        if (!matcher.matches()) {
            return null;
        }
        String id = matcher.group(1);
        if (block.getTypeId() != 68) {
            throw new InvalidMechanismException("Only wall signs are used for ICs.");
        }
        RegisteredICFactory registration = this.manager.get(id);
        if (registration == null) {
            throw new InvalidMechanismException("Unknown IC detected: " + id);
        }
        ICFactory factory = registration.getFactory();
        if (factory instanceof RestrictedIC ? !player.hasPermission("craftbook.ic.restricted." + id.toLowerCase()) : !player.hasPermission("craftbook.ic.safe." + id.toLowerCase())) {
            throw new ICVerificationException("You don't have permission to use " + registration.getId() + ".");
        }
        factory.verify(sign);
        IC ic = registration.getFactory().create(sign);
        sign.setLine(1, "[" + registration.getId() + "]");
        ICMechanic mechanic = ic instanceof SelfTriggeredIC ? new SelfTriggeredICMechanic(this.plugin, id, (SelfTriggeredIC)ic, registration.getFamily(), pt) : new ICMechanic(this.plugin, id, ic, registration.getFamily(), pt);
        sign.setLine(0, ic.getSignTitle());
        player.print("You've created " + registration.getId() + ": " + ic.getTitle() + ".");
        return mechanic;
    }
}

