/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic.families;

import com.sk89q.craftbook.ic.AbstractICFamily;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class Family3I3O
extends AbstractICFamily {
    public ChipState detect(BlockWorldVector source, Sign sign) {
        return new ChipState3I3O(source, sign);
    }

    public static class ChipState3I3O
    implements ChipState {
        protected Sign sign;
        protected BlockWorldVector source;

        public ChipState3I3O(BlockWorldVector source, Sign sign) {
            this.sign = sign;
            this.source = source;
        }

        protected Block getBlock(int pin) {
            Block bsign = this.sign.getBlock();
            BlockFace fback = SignUtil.getBack(bsign);
            switch (pin) {
                case 0: {
                    return SignUtil.getFrontBlock(bsign);
                }
                case 1: {
                    return SignUtil.getLeftBlock(this.sign.getBlock());
                }
                case 2: {
                    return SignUtil.getRightBlock(this.sign.getBlock());
                }
                case 3: {
                    return bsign.getRelative(fback).getRelative(fback).getRelative(fback);
                }
                case 4: {
                    return bsign.getRelative(fback).getRelative(fback).getRelative(SignUtil.getCounterClockWise(fback));
                }
                case 5: {
                    return bsign.getRelative(fback).getRelative(fback).getRelative(SignUtil.getClockWise(fback));
                }
            }
            return null;
        }

        public boolean get(int pin) {
            Block block = this.getBlock(pin);
            if (block != null) {
                return block.isBlockIndirectlyPowered();
            }
            return false;
        }

        public void set(int pin, boolean value) {
            Block block = this.getBlock(pin);
            if (block == null) {
                return;
            }
            ICUtil.setState(block, value);
        }

        public boolean isTriggered(int pin) {
            Block block = this.getBlock(pin);
            if (block != null) {
                return BukkitUtil.toWorldVector((Block)block).equals((Object)this.source);
            }
            return false;
        }

        public boolean isValid(int pin) {
            Block block = this.getBlock(pin);
            if (block != null) {
                return block.getType() == Material.REDSTONE_WIRE;
            }
            return false;
        }

        public boolean getInput(int inputIndex) {
            return this.get(inputIndex);
        }

        public boolean getOutput(int outputIndex) {
            return this.get(outputIndex + 3);
        }

        public void setOutput(int outputIndex, boolean value) {
            this.set(outputIndex + 3, value);
        }

        public int getInputCount() {
            return 3;
        }

        public int getOutputCount() {
            return 3;
        }
    }
}

