/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.VehiclesConfiguration;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.MinecartManager;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockListener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleListener;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;

public class VehiclesPlugin
extends BaseBukkitPlugin {
    private VehiclesConfiguration config;
    private VehicleListener lvehicle;
    private BlockListener lblock;
    private MinecartManager cartman;

    public void onEnable() {
        super.onEnable();
        this.cartman = new MinecartManager(this);
    }

    protected void registerEvents() {
        this.createDefaultConfiguration("config.yml");
        this.config = new VehiclesConfiguration(this.getConfiguration(), this.getDataFolder());
        this.lvehicle = new CraftBookVehicleListener();
        this.lblock = new CraftBookVehicleBlockListener();
        this.getServer().getPluginManager().registerEvent(Event.Type.VEHICLE_CREATE, (Listener)this.lvehicle, Event.Priority.Normal, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.VEHICLE_MOVE, (Listener)this.lvehicle, Event.Priority.Normal, (Plugin)this);
        this.getServer().getPluginManager().registerEvent(Event.Type.REDSTONE_CHANGE, (Listener)this.lblock, Event.Priority.Normal, (Plugin)this);
    }

    public VehiclesConfiguration getLocalConfiguration() {
        return this.config;
    }

    class CraftBookVehicleBlockListener
    extends BlockListener {
        public void onBlockRedstoneChange(BlockRedstoneEvent event) {
            if (event.getOldCurrent() > 0 == event.getNewCurrent() > 0) {
                return;
            }
            for (BlockFace bf : CartMechanism.powerSupplyOptions) {
                VehiclesPlugin.this.cartman.impact(new SourcedBlockRedstoneEvent(event, event.getBlock().getFace(bf)));
            }
        }
    }

    class CraftBookVehicleListener
    extends VehicleListener {
        public void onVehicleCreate(VehicleCreateEvent event) {
            Vehicle vehicle = event.getVehicle();
            if (!(vehicle instanceof Minecart)) {
                return;
            }
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            Minecart minecart = (Minecart)vehicle;
            minecart.setSlowWhenEmpty(config.minecartSlowWhenEmpty);
            minecart.setMaxSpeed(minecart.getMaxSpeed() * config.minecartMaxSpeedModifier);
        }

        public void onVehicleMove(VehicleMoveEvent event) {
            if (!(event.getVehicle() instanceof Minecart)) {
                return;
            }
            VehiclesPlugin.this.cartman.impact(event);
        }
    }
}

