/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.RedstoneUtil;
import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.CartMechanismBlocks;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Location;
import org.bukkit.block.Chest;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CartDispenser
extends CartMechanism {
    public void impact(Minecart cart, CartMechanismBlocks blocks, boolean minor) {
        Inventory inv;
        if (minor) {
            return;
        }
        if (!blocks.matches("dispenser")) {
            return;
        }
        RedstoneUtil.Power pow = this.isActive(blocks.rail, blocks.base, blocks.sign);
        boolean inf = "inf".equalsIgnoreCase(blocks.getSign().getLines()[2]);
        Inventory inventory = inv = inf ? null : ((Chest)blocks.base.getState()).getInventory();
        if (cart == null) {
            switch (pow) {
                case ON: {
                    this.dispense(blocks, inv);
                    return;
                }
                case OFF: 
                case NA: {
                    return;
                }
            }
        } else {
            switch (pow) {
                case ON: {
                    return;
                }
                case OFF: 
                case NA: {
                    this.collect(cart, inv);
                    return;
                }
            }
        }
    }

    private void collect(Minecart cart, Inventory inv) {
        cart.eject();
        cart.setDamage(9000);
        cart.remove();
        if (inv != null) {
            int cartType = ItemType.MINECART.getID();
            if (cart instanceof StorageMinecart) {
                cartType = ItemType.STORAGE_MINECART.getID();
            } else if (cart instanceof PoweredMinecart) {
                cartType = ItemType.POWERED_MINECART.getID();
            }
            inv.addItem(new ItemStack[]{new ItemStack(cartType, 1)});
        }
    }

    private void dispense(CartMechanismBlocks blocks, Inventory inv) {
        if (inv != null) {
            if (!inv.contains(ItemType.MINECART.getID())) {
                return;
            }
            inv.removeItem(new ItemStack[]{new ItemStack(ItemType.MINECART.getID(), 1)});
        }
        blocks.rail.getWorld().spawn(BukkitUtil.center((Location)blocks.rail.getLocation()), Minecart.class);
    }
}

