/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.MechanismsConfiguration;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.BukkitPlayer;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.regions.CuboidRegion;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

public class Bridge
extends AbstractMechanic {
    private MechanismsPlugin plugin;
    private MechanismsConfiguration.BridgeSettings settings;
    private Block trigger;
    private Block proximalBaseCenter;
    private Block farside;
    private CuboidRegion toggle;

    private Bridge(Block trigger, MechanismsPlugin plugin) throws InvalidMechanismException {
        String otherSignText;
        if (!SignUtil.isCardinal(trigger)) {
            throw new InvalidDirectionException();
        }
        BlockFace dir = SignUtil.getFacing(trigger);
        this.trigger = trigger;
        this.plugin = plugin;
        this.settings = plugin.getLocalConfiguration().bridgeSettings;
        this.proximalBaseCenter = trigger.getFace(BlockFace.UP);
        Material mat = this.proximalBaseCenter.getType();
        if (!this.settings.canUseBlock(mat) || this.proximalBaseCenter.getFace(SignUtil.getLeft(trigger)).getType() != mat || this.proximalBaseCenter.getFace(SignUtil.getRight(trigger)).getType() != mat) {
            this.proximalBaseCenter = trigger.getFace(BlockFace.DOWN);
            mat = this.proximalBaseCenter.getType();
            if (this.settings.canUseBlock(mat)) {
                if (this.proximalBaseCenter.getFace(SignUtil.getLeft(trigger)).getType() != mat || this.proximalBaseCenter.getFace(SignUtil.getRight(trigger)).getType() != mat) {
                    throw new InvalidConstructionException("Blocks adjacent to the bridge block must be of the same type.");
                }
            } else {
                throw new UnacceptableMaterialException();
            }
        }
        this.farside = trigger.getFace(dir);
        for (int i = 0; i <= this.settings.maxLength && (this.farside.getType() != Material.SIGN_POST || !"[Bridge]".equalsIgnoreCase(otherSignText = ((Sign)this.farside.getState()).getLines()[1]) && !"[Bridge End]".equalsIgnoreCase(otherSignText)); ++i) {
            this.farside = this.farside.getFace(dir);
        }
        if (this.farside.getType() != Material.SIGN_POST) {
            throw new InvalidConstructionException("[Bridge] sign required on other side (or it was too far away).");
        }
        Block distalBaseCenter = this.farside.getFace(trigger.getFace(this.proximalBaseCenter));
        if (distalBaseCenter.getType() != mat || distalBaseCenter.getFace(SignUtil.getLeft(trigger)).getType() != mat || distalBaseCenter.getFace(SignUtil.getRight(trigger)).getType() != mat) {
            throw new InvalidConstructionException("The other side must be made with the same blocks.");
        }
        this.toggle = new CuboidRegion((Vector)BukkitUtil.toVector((Block)this.proximalBaseCenter), (Vector)BukkitUtil.toVector((Block)distalBaseCenter));
        this.toggle.contract((Vector)BukkitUtil.toVector((BlockFace)SignUtil.getBack(trigger)));
        this.toggle.contract((Vector)BukkitUtil.toVector((BlockFace)SignUtil.getFront(trigger)));
        this.toggle.expand((Vector)BukkitUtil.toVector((BlockFace)SignUtil.getLeft(trigger)));
        this.toggle.expand((Vector)BukkitUtil.toVector((BlockFace)SignUtil.getRight(trigger)));
    }

    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().bridgeSettings.enable) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getClickedBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        BukkitPlayer player = new BukkitPlayer(this.plugin, event.getPlayer());
        if (!player.hasPermission("craftbook.mech.bridge.use")) {
            player.printError("You don't have permission to use bridges.");
            return;
        }
        this.flipState();
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.plugin.getLocalConfiguration().bridgeSettings.enableRedstone) {
            return;
        }
        if (!BukkitUtil.toWorldVector((Block)event.getBlock()).equals((Object)BukkitUtil.toWorldVector((Block)this.trigger))) {
            return;
        }
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        if (event.getNewCurrent() == 0) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new ToggleRegionOpen(), 2L);
        } else {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new ToggleRegionClosed(), 2L);
        }
    }

    private void flipState() {
        Block hinge = this.proximalBaseCenter.getFace(SignUtil.getFacing(this.trigger));
        if (Bridge.canPassThrough(hinge.getType())) {
            new ToggleRegionClosed().run();
        } else {
            new ToggleRegionOpen().run();
        }
    }

    private Material getBridgeMaterial() {
        return this.proximalBaseCenter.getType();
    }

    private static boolean canPassThrough(Material t) {
        switch (t) {
            case AIR: 
            case WATER: 
            case STATIONARY_WATER: 
            case LAVA: 
            case STATIONARY_LAVA: 
            case SNOW: {
                return true;
            }
        }
        return false;
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    private static class InvalidConstructionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = 8758644926222590049L;

        public InvalidConstructionException(String msg) {
            super(msg);
        }
    }

    private static class UnacceptableMaterialException
    extends InvalidMechanismException {
        private static final long serialVersionUID = -2856504362189922160L;

        private UnacceptableMaterialException() {
        }
    }

    private static class InvalidDirectionException
    extends InvalidMechanismException {
        private static final long serialVersionUID = -8169241147023551662L;

        private InvalidDirectionException() {
        }
    }

    private class ToggleRegionClosed
    implements Runnable {
        private ToggleRegionClosed() {
        }

        public void run() {
            for (BlockVector bv : Bridge.this.toggle) {
                Block b = Bridge.this.trigger.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
                if (!Bridge.canPassThrough(b.getType())) continue;
                b.setType(Bridge.this.getBridgeMaterial());
            }
        }
    }

    private class ToggleRegionOpen
    implements Runnable {
        private ToggleRegionOpen() {
        }

        public void run() {
            for (BlockVector bv : Bridge.this.toggle) {
                Block b = Bridge.this.trigger.getWorld().getBlockAt(bv.getBlockX(), bv.getBlockY(), bv.getBlockZ());
                if (b.getType() != Bridge.this.getBridgeMaterial() && !Bridge.canPassThrough(b.getType())) continue;
                b.setType(Material.AIR);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Bridge> {
        private MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public Bridge detect(BlockWorldVector pt) throws InvalidMechanismException {
            Block block = BukkitUtil.toBlock((BlockWorldVector)pt);
            if (block.getTypeId() != 63) {
                return null;
            }
            if (!((Sign)block.getState()).getLine(1).equalsIgnoreCase("[Bridge]")) {
                return null;
            }
            return new Bridge(block, this.plugin);
        }

        @Override
        public Bridge detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Bridge]")) {
                if (!player.hasPermission("craftbook.mech.bridge")) {
                    throw new InsufficientPermissionsException();
                }
                sign.setLine(1, "[Bridge]");
                player.print("Bridge created.");
            } else if (sign.getLine(1).equalsIgnoreCase("[Bridge End]")) {
                if (!player.hasPermission("craftbook.mech.bridge")) {
                    throw new InsufficientPermissionsException();
                }
                sign.setLine(1, "[Bridge End]");
                player.print("Bridge endpoint created.");
            } else {
                return null;
            }
            throw new ProcessedMechanismException();
        }
    }
}

