/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.LocalWorld;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gate
extends AbstractMechanic {
    protected MechanismsPlugin plugin;
    protected BlockWorldVector pt;
    protected boolean smallSearchSize;

    public Gate(BlockWorldVector pt, MechanismsPlugin plugin, boolean smallSearchSize) {
        this.pt = pt;
        this.plugin = plugin;
        this.smallSearchSize = smallSearchSize;
    }

    public boolean toggleGates(WorldVector pt, boolean smallSearchSize) {
        LocalWorld world = pt.getWorld();
        int x = pt.getBlockX();
        int y = pt.getBlockY();
        int z = pt.getBlockZ();
        boolean foundGate = false;
        HashSet<BlockVector> visitedColumns = new HashSet<BlockVector>();
        if (smallSearchSize) {
            for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                for (int y1 = y - 2; y1 <= y + 1; ++y1) {
                    for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                        if (!this.recurseColumn(new WorldVector(world, x1, y1, z1), visitedColumns, null)) continue;
                        foundGate = true;
                    }
                }
            }
        } else {
            for (int x1 = x - 3; x1 <= x + 3; ++x1) {
                for (int y1 = y - 3; y1 <= y + 6; ++y1) {
                    for (int z1 = z - 3; z1 <= z + 3; ++z1) {
                        if (!this.recurseColumn(new WorldVector(world, x1, y1, z1), visitedColumns, null)) continue;
                        foundGate = true;
                    }
                }
            }
        }
        return foundGate;
    }

    public boolean setGateState(WorldVector pt, boolean close, boolean smallSearchSize) {
        LocalWorld world = pt.getWorld();
        int x = pt.getBlockX();
        int y = pt.getBlockY();
        int z = pt.getBlockZ();
        boolean foundGate = false;
        HashSet<BlockVector> visitedColumns = new HashSet<BlockVector>();
        if (smallSearchSize) {
            for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                for (int y1 = y - 2; y1 <= y + 1; ++y1) {
                    for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                        if (!this.recurseColumn(new WorldVector(world, x1, y1, z1), visitedColumns, close)) continue;
                        foundGate = true;
                    }
                }
            }
        } else {
            for (int x1 = x - 3; x1 <= x + 3; ++x1) {
                for (int y1 = y - 3; y1 <= y + 6; ++y1) {
                    for (int z1 = z - 3; z1 <= z + 3; ++z1) {
                        if (!this.recurseColumn(new WorldVector(world, x1, y1, z1), visitedColumns, close)) continue;
                        foundGate = true;
                    }
                }
            }
        }
        return foundGate;
    }

    private boolean recurseColumn(WorldVector pt, Set<BlockVector> visitedColumns, Boolean close) {
        World world = ((BukkitWorld)pt.getWorld()).getWorld();
        if (visitedColumns.size() > 14) {
            return false;
        }
        if (visitedColumns.contains(pt.setY(0).toBlockVector())) {
            return false;
        }
        if (world.getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pt)) != 85) {
            return false;
        }
        int x = pt.getBlockX();
        int y = pt.getBlockY();
        int z = pt.getBlockZ();
        visitedColumns.add(pt.setY(0).toBlockVector());
        int y1 = y + 1;
        while (y1 <= y + 12 && world.getBlockTypeIdAt(x, y1, z) == 85) {
            y = y1++;
        }
        if (world.getBlockTypeIdAt(x, y + 1, z) == 0) {
            return false;
        }
        if (close == null) {
            close = world.getBlockTypeIdAt(x, y - 1, z) != 85;
        }
        this.toggleColumn((WorldVector)new BlockWorldVector(pt, x, y, z), close, visitedColumns);
        return true;
    }

    private void toggleColumn(WorldVector topPoint, boolean close, Set<BlockVector> visitedColumns) {
        int cur;
        World world = ((BukkitWorld)topPoint.getWorld()).getWorld();
        int x = topPoint.getBlockX();
        int y = topPoint.getBlockY();
        int z = topPoint.getBlockZ();
        int minY = Math.max(0, y - 12);
        for (int y1 = y - 1; y1 >= minY && ((cur = world.getBlockTypeIdAt(x, y1, z)) == 8 || cur == 9 || cur == 10 || cur == 11 || cur == 85 || cur == 0); --y1) {
            world.getBlockAt(x, y1, z).setTypeId(close ? 85 : 0);
            BlockWorldVector pt = new BlockWorldVector(topPoint, x, y1, z);
            this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, pt.add(1, 0, 0)), visitedColumns, close);
            this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, pt.add(-1, 0, 0)), visitedColumns, close);
            this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, pt.add(0, 0, 1)), visitedColumns, close);
            this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, pt.add(0, 0, -1)), visitedColumns, close);
        }
        this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, topPoint.add(1, 0, 0)), visitedColumns, close);
        this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, topPoint.add(-1, 0, 0)), visitedColumns, close);
        this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, topPoint.add(0, 0, 1)), visitedColumns, close);
        this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, topPoint.add(0, 0, -1)), visitedColumns, close);
        this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, topPoint.add(1, 1, 0)), visitedColumns, close);
        this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, topPoint.add(-1, 1, 0)), visitedColumns, close);
        this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, topPoint.add(0, 1, 1)), visitedColumns, close);
        this.recurseColumn((WorldVector)new BlockWorldVector(topPoint, topPoint.add(0, 1, -1)), visitedColumns, close);
    }

    @Override
    public void onRightClick(PlayerInteractEvent event) {
        if (!this.plugin.getLocalConfiguration().gateSettings.enable) {
            return;
        }
        LocalPlayer player = this.plugin.wrap(event.getPlayer());
        if (this.toggleGates((WorldVector)this.pt, this.smallSearchSize)) {
            player.print("Gate toggled!");
        } else {
            player.printError("Failed to find a gate!");
        }
    }

    @Override
    public void onBlockRedstoneChange(final SourcedBlockRedstoneEvent event) {
        if (!this.plugin.getLocalConfiguration().gateSettings.enableRedstone) {
            return;
        }
        if (event.getNewCurrent() == event.getOldCurrent()) {
            return;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                Gate.this.setGateState((WorldVector)Gate.this.pt, event.getNewCurrent() > 0, Gate.this.smallSearchSize);
            }
        }, 2L);
    }

    @Override
    public void unload() {
    }

    @Override
    public boolean isActive() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Gate> {
        protected MechanismsPlugin plugin;

        public Factory(MechanismsPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public Gate detect(BlockWorldVector pt) {
            Sign sign;
            BlockState state;
            Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
            if (block.getTypeId() == 68 && (state = block.getState()) instanceof Sign && ((sign = (Sign)state).getLine(1).equalsIgnoreCase("[Gate]") || sign.getLine(1).equalsIgnoreCase("[DGate]"))) {
                return new Gate(pt, this.plugin, sign.getLine(1).equalsIgnoreCase("[DGate]"));
            }
            return null;
        }

        @Override
        public Gate detect(BlockWorldVector pt, LocalPlayer player, Sign sign) throws InvalidMechanismException, ProcessedMechanismException {
            if (sign.getLine(1).equalsIgnoreCase("[Gate]")) {
                if (!player.hasPermission("craftbook.mech.gate")) {
                    throw new InsufficientPermissionsException();
                }
                sign.setLine(1, "[Gate]");
                player.print("Gate created.");
            } else if (sign.getLine(1).equalsIgnoreCase("[DGate]")) {
                if (!player.hasPermission("craftbook.mech.gate")) {
                    throw new InsufficientPermissionsException();
                }
                sign.setLine(1, "[DGate]");
                player.print("Small gate created.");
            } else {
                return null;
            }
            throw new ProcessedMechanismException();
        }
    }
}

