/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.Mechanic;
import com.sk89q.craftbook.MechanicFactory;
import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.ProcessedMechanismException;
import com.sk89q.craftbook.SelfTriggeringMechanic;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.TriggerBlockManager;
import com.sk89q.craftbook.WatchBlockManager;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.bukkit.ChangedSign;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.BlockWorldVector2D;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.Event;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MechanicManager {
    public static final boolean DEBUG = false;
    protected final Logger logger = Logger.getLogger("Minecraft.CraftBook");
    protected final BaseBukkitPlugin plugin;
    protected final LinkedList<MechanicFactory<? extends Mechanic>> factories;
    private final TriggerBlockManager triggersManager;
    private final WatchBlockManager watchBlockManager;
    private Set<SelfTriggeringMechanic> thinkingMechanics = new LinkedHashSet<SelfTriggeringMechanic>();

    public MechanicManager(BaseBukkitPlugin plugin) {
        this.plugin = plugin;
        this.factories = new LinkedList();
        this.triggersManager = new TriggerBlockManager();
        this.watchBlockManager = new WatchBlockManager();
    }

    public void register(MechanicFactory<? extends Mechanic> factory) {
        this.factories.add(factory);
    }

    public boolean dispatchSignChange(SignChangeEvent event) {
        if (!this.passesFilter((Event)event)) {
            return false;
        }
        Block block = event.getBlock();
        BlockWorldVector pos = BukkitUtil.toWorldVector((Block)block);
        LocalPlayer localPlayer = this.plugin.wrap(event.getPlayer());
        BlockState state = event.getBlock().getState();
        if (!(state instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)state;
        try {
            this.load(pos, localPlayer, new ChangedSign(sign, event.getLines()));
        }
        catch (InvalidMechanismException e) {
            if (e.getMessage() != null) {
                localPlayer.printError(e.getMessage());
            }
            event.setCancelled(true);
            block.getWorld().dropItem(block.getLocation(), new ItemStack(Material.SIGN, 1));
            block.setTypeId(0);
        }
        return false;
    }

    public boolean dispatchBlockRightClick(PlayerInteractEvent event) {
        block4: {
            if (!this.passesFilter((Event)event)) {
                return false;
            }
            BlockWorldVector pos = BukkitUtil.toWorldVector((Block)event.getClickedBlock());
            try {
                Mechanic mechanic = this.load(pos);
                if (mechanic != null) {
                    mechanic.onRightClick(event);
                    return true;
                }
            }
            catch (InvalidMechanismException e) {
                if (e.getMessage() == null) break block4;
                event.getPlayer().sendMessage(e.getMessage());
            }
        }
        return false;
    }

    public boolean dispatchBlockLeftClick(PlayerInteractEvent event) {
        block4: {
            if (!this.passesFilter((Event)event)) {
                return false;
            }
            BlockWorldVector pos = BukkitUtil.toWorldVector((Block)event.getClickedBlock());
            try {
                Mechanic mechanic = this.load(pos);
                if (mechanic != null) {
                    mechanic.onLeftClick(event);
                    return true;
                }
            }
            catch (InvalidMechanismException e) {
                if (e.getMessage() == null) break block4;
                event.getPlayer().sendMessage(e.getMessage());
            }
        }
        return false;
    }

    public boolean dispatchBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (!this.passesFilter((Event)event)) {
            return false;
        }
        BlockWorldVector pos = BukkitUtil.toWorldVector((Block)event.getBlock());
        try {
            Mechanic mechanic = this.load(pos);
            if (mechanic != null) {
                mechanic.onBlockRedstoneChange(event);
                return true;
            }
        }
        catch (InvalidMechanismException invalidMechanismException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mechanic load(BlockWorldVector pos) throws InvalidMechanismException {
        Mechanic mechanic = this.triggersManager.get(pos);
        if (mechanic != null) {
            if (mechanic.isActive()) {
                return mechanic;
            }
            this.unload(mechanic);
        }
        if ((mechanic = this.detect(pos)) == null) {
            return null;
        }
        if (mechanic instanceof PersistentMechanic) {
            Mechanic pm = mechanic;
            this.triggersManager.register((PersistentMechanic)pm);
            this.watchBlockManager.register((PersistentMechanic)pm);
            if (mechanic instanceof SelfTriggeringMechanic) {
                MechanicManager mechanicManager = this;
                synchronized (mechanicManager) {
                    this.thinkingMechanics.add((SelfTriggeringMechanic)mechanic);
                }
            }
        }
        return mechanic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Mechanic load(BlockWorldVector pos, LocalPlayer player, Sign sign) throws InvalidMechanismException {
        Mechanic mechanic = this.triggersManager.get(pos);
        if (mechanic != null) {
            if (mechanic.isActive()) {
                return mechanic;
            }
            this.unload(mechanic);
        }
        if ((mechanic = this.detect(pos, player, sign)) == null) {
            return null;
        }
        if (mechanic instanceof PersistentMechanic) {
            Mechanic pm = mechanic;
            this.triggersManager.register((PersistentMechanic)pm);
            this.watchBlockManager.register((PersistentMechanic)pm);
            if (mechanic instanceof SelfTriggeringMechanic) {
                MechanicManager mechanicManager = this;
                synchronized (mechanicManager) {
                    this.thinkingMechanics.add((SelfTriggeringMechanic)mechanic);
                }
            }
        }
        return mechanic;
    }

    protected Mechanic detect(BlockWorldVector pos) throws InvalidMechanismException {
        Mechanic mechanic = null;
        for (MechanicFactory mechanicFactory : this.factories) {
            Object t = mechanicFactory.detect(pos);
            mechanic = (Mechanic)t;
            if (t == null) continue;
            break;
        }
        return mechanic;
    }

    protected Mechanic detect(BlockWorldVector pos, LocalPlayer player, Sign sign) throws InvalidMechanismException {
        Mechanic mechanic = null;
        for (MechanicFactory mechanicFactory : this.factories) {
            try {
                Object t = mechanicFactory.detect(pos, player, sign);
                mechanic = (Mechanic)t;
                if (t == null) continue;
            }
            catch (ProcessedMechanismException e) {}
            break;
        }
        return mechanic;
    }

    protected boolean passesFilter(Event event) {
        return true;
    }

    public void enumerate(Chunk chunk) {
        for (BlockState state : chunk.getTileEntities()) {
            if (!(state instanceof Sign)) continue;
            try {
                try {
                    this.load(BukkitUtil.toWorldVector((Block)state.getBlock()));
                }
                catch (NullPointerException t) {
                    t.printStackTrace();
                }
            }
            catch (InvalidMechanismException e) {
                // empty catch block
            }
        }
    }

    public void unload(BlockWorldVector2D chunk) {
        Set<PersistentMechanic> applicable = this.triggersManager.getByChunk(chunk);
        applicable.addAll(this.watchBlockManager.getByChunk(chunk));
        for (PersistentMechanic m : applicable) {
            this.unload(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unload(Mechanic mechanic) {
        if (mechanic == null) {
            this.logger.log(Level.WARNING, "CraftBook mechanic: Failed to unload(Mechanic) - null.");
            return;
        }
        try {
            mechanic.unload();
        }
        catch (Throwable t) {
            this.logger.log(Level.WARNING, "CraftBook mechanic: Failed to unload " + mechanic.getClass().getCanonicalName(), t);
        }
        MechanicManager t = this;
        synchronized (t) {
            this.thinkingMechanics.remove(mechanic);
        }
        if (mechanic instanceof PersistentMechanic) {
            PersistentMechanic pm = (PersistentMechanic)mechanic;
            this.triggersManager.deregister(pm);
            this.watchBlockManager.deregister(pm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void think() {
        SelfTriggeringMechanic[] mechs;
        MechanicManager mechanicManager = this;
        synchronized (mechanicManager) {
            mechs = new SelfTriggeringMechanic[this.thinkingMechanics.size()];
            this.thinkingMechanics.toArray(mechs);
        }
        for (SelfTriggeringMechanic mechanic : mechs) {
            if (mechanic.isActive()) {
                try {
                    mechanic.think();
                }
                catch (Throwable t) {
                    this.logger.log(Level.WARNING, "CraftBook mechanic: Failed to think for " + mechanic.getClass().getCanonicalName(), t);
                }
                continue;
            }
            this.unload(mechanic);
        }
    }
}

