/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public abstract class RedstoneUtil {
    public static Power isPowered(Block mech, BlockFace face) {
        Block pow = mech.getFace(face);
        if (RedstoneUtil.isPotentialPowerSource(mech, pow)) {
            if (pow.isBlockPowered() || pow.isBlockIndirectlyPowered()) {
                return Power.ON;
            }
            return Power.OFF;
        }
        return Power.NA;
    }

    public static boolean isPotentialPowerSource(Block pow) {
        return pow.getType() == Material.REDSTONE_WIRE;
    }

    public static boolean isPotentialPowerSource(Block mech, Block pow) {
        return pow.getType() == Material.REDSTONE_WIRE;
    }

    public static void debug(Block block) {
        System.out.println("block " + block + " power debug:");
        System.out.println("\tblock.isBlockPowered() : " + block.isBlockPowered());
        System.out.println("\tblock.isBlockIndirectlyPowered() : " + block.isBlockIndirectlyPowered());
        for (BlockFace bf : BlockFace.values()) {
            System.out.println("\tblock.isBlockFacePowered(" + bf + ") : " + block.isBlockFacePowered(bf));
            System.out.println("\tblock.getFace(" + bf + ").isBlockPowered() : " + block.getFace(bf).isBlockPowered());
            System.out.println("\tblock.isBlockFaceIndirectlyPowered(" + bf + ") : " + block.isBlockFaceIndirectlyPowered(bf));
            System.out.println("\tblock.getFace(" + bf + ").isBlockIndirectlyPowered(" + bf + ") : " + block.getFace(bf).isBlockIndirectlyPowered());
        }
        System.out.println();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Power {
        NA,
        ON,
        OFF;

    }
}

