/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.bukkit.migration.PermissionsResolverManager;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.bukkit.BukkitPlayer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class BaseBukkitPlugin
extends JavaPlugin {
    private PermissionsResolverManager perms;
    protected static final Logger logger = Logger.getLogger("Minecraft.CraftBook");

    public void onLoad() {
    }

    public void onEnable() {
        logger.info(this.getDescription().getName() + " " + this.getDescription().getVersion() + " enabled.");
        this.getDataFolder().mkdirs();
        this.perms = new PermissionsResolverManager(this.getConfiguration(), this.getServer(), this.getDescription().getName(), logger);
        this.perms.load();
        this.registerEvents();
    }

    public void onDisable() {
    }

    protected abstract void registerEvents();

    protected void registerEvent(Event.Type type, Listener listener, Event.Priority priority) {
        this.getServer().getPluginManager().registerEvent(type, listener, priority, (Plugin)this);
    }

    protected void registerEvent(Event.Type type, Listener listener) {
        this.getServer().getPluginManager().registerEvent(type, listener, Event.Priority.Normal, (Plugin)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultConfiguration(String name) {
        InputStream input;
        File actual = new File(this.getDataFolder(), name);
        if (!actual.exists() && (input = ((Object)((Object)this)).getClass().getResourceAsStream("/defaults/" + name)) != null) {
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(actual);
                byte[] buf = new byte[8192];
                int length = 0;
                while ((length = input.read(buf)) > 0) {
                    output.write(buf, 0, length);
                }
                logger.info(this.getDescription().getName() + ": Default configuration file written: " + name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {}
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    public LocalPlayer wrap(Player player) {
        return new BukkitPlayer(this, player);
    }

    public boolean hasPermission(CommandSender sender, String perm) {
        if (sender.isOp()) {
            return true;
        }
        if (sender instanceof Player) {
            return this.perms.hasPermission(((Player)sender).getName(), perm);
        }
        return false;
    }
}

