/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class CartMechanismBlocks {
    public final Block rail;
    public final Block base;
    public final Block sign;
    public Block from;

    private CartMechanismBlocks(Block rail, Block base, Block sign) {
        this.rail = rail;
        this.base = base;
        this.sign = sign;
    }

    public static CartMechanismBlocks find(Block unknown) throws InvalidMechanismException {
        int ti = unknown.getTypeId();
        if (SignUtil.isSign(ti)) {
            return CartMechanismBlocks.findBySign(unknown);
        }
        if (BlockType.isRailBlock((int)ti)) {
            return CartMechanismBlocks.findByRail(unknown);
        }
        return CartMechanismBlocks.findByBase(unknown);
    }

    public static CartMechanismBlocks findByRail(Block rail) throws InvalidMechanismException {
        if (!BlockType.isRailBlock((int)rail.getTypeId())) {
            throw new InvalidMechanismException("rail argument must be a rail!");
        }
        if (SignUtil.isSign(rail.getFace(BlockFace.DOWN, 2).getTypeId())) {
            return new CartMechanismBlocks(rail, rail.getFace(BlockFace.DOWN, 1), rail.getFace(BlockFace.DOWN, 2));
        }
        if (SignUtil.isSign(rail.getFace(BlockFace.DOWN, 3).getTypeId())) {
            return new CartMechanismBlocks(rail, rail.getFace(BlockFace.DOWN, 1), rail.getFace(BlockFace.DOWN, 3));
        }
        return new CartMechanismBlocks(rail, rail.getFace(BlockFace.DOWN, 1), null);
    }

    public static CartMechanismBlocks findByBase(Block base) throws InvalidMechanismException {
        if (!BlockType.isRailBlock((int)base.getFace(BlockFace.UP, 1).getTypeId())) {
            throw new InvalidMechanismException("could not find rails.");
        }
        if (SignUtil.isSign(base.getFace(BlockFace.DOWN, 1).getTypeId())) {
            return new CartMechanismBlocks(base.getFace(BlockFace.UP, 1), base, base.getFace(BlockFace.DOWN, 1));
        }
        if (SignUtil.isSign(base.getFace(BlockFace.DOWN, 2).getTypeId())) {
            return new CartMechanismBlocks(base.getFace(BlockFace.UP, 1), base, base.getFace(BlockFace.DOWN, 2));
        }
        return new CartMechanismBlocks(base.getFace(BlockFace.UP, 1), base, null);
    }

    public static CartMechanismBlocks findBySign(Block sign) throws InvalidMechanismException {
        if (!SignUtil.isSign(sign)) {
            throw new InvalidMechanismException("sign argument must be a sign!");
        }
        if (BlockType.isRailBlock((int)sign.getFace(BlockFace.UP, 2).getTypeId())) {
            return new CartMechanismBlocks(sign.getFace(BlockFace.UP, 2), sign.getFace(BlockFace.UP, 1), sign);
        }
        if (BlockType.isRailBlock((int)sign.getFace(BlockFace.UP, 3).getTypeId())) {
            return new CartMechanismBlocks(sign.getFace(BlockFace.UP, 3), sign.getFace(BlockFace.UP, 2), sign);
        }
        throw new InvalidMechanismException("could not find rails.");
    }

    public void setFromBlock(Block block) {
        this.from = block;
    }

    public boolean matches(String mechname) {
        return this.sign == null ? false : ((Sign)this.sign.getState()).getLine(1).equalsIgnoreCase("[" + mechname + "]");
    }

    public boolean matches(Material mat) {
        return this.base.getType() == mat;
    }

    public Sign getSign() {
        return this.sign == null ? null : (Sign)this.sign.getState();
    }
}

