/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.circuits;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;

public class GlowStone
extends AbstractMechanic {
    private GlowStone(BlockWorldVector pt) {
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        byte data = event.getBlock().getData();
        if (event.getNewCurrent() > 0) {
            event.getBlock().setTypeId(89);
        } else {
            event.getBlock().setTypeId(20);
        }
        event.getBlock().setData(data, false);
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<GlowStone> {
        @Override
        public GlowStone detect(BlockWorldVector pt) {
            int type = BukkitUtil.toWorld((WorldVector)pt).getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pt));
            if (type == 20 || type == 89) {
                return new GlowStone(pt);
            }
            return null;
        }
    }
}

