/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Sign;
import org.bukkit.entity.CreatureType;

public class CreatureSpawner
extends AbstractIC {
    protected boolean risingEdge;

    public CreatureSpawner(Server server, Sign sign, boolean risingEdge) {
        super(server, sign);
        this.risingEdge = risingEdge;
    }

    public String getTitle() {
        return "Creature Spawner";
    }

    public String getSignTitle() {
        return "CREATURE SPAWNER";
    }

    public void trigger(ChipState chip) {
        if (this.risingEdge && chip.getInput(0) || !this.risingEdge && !chip.getInput(0)) {
            String type = this.getSign().getLine(2).trim();
            String rider = this.getSign().getLine(3).trim();
            if (CreatureType.fromName((String)type) != null) {
                Location loc = this.getSign().getBlock().getLocation();
                int maxY = Math.min(128, loc.getBlockY() + 10);
                int x = loc.getBlockX();
                int z = loc.getBlockZ();
                for (int y = loc.getBlockY() + 1; y <= maxY; ++y) {
                    if (!BlockType.canPassThrough((int)this.getSign().getWorld().getBlockTypeIdAt(x, y, z))) continue;
                    if (rider.length() != 0 && CreatureType.fromName((String)rider) != null) {
                        this.getSign().getWorld().spawnCreature(new Location(this.getSign().getWorld(), (double)x, (double)y, (double)z), CreatureType.fromName((String)type));
                    } else {
                        this.getSign().getWorld().spawnCreature(new Location(this.getSign().getWorld(), (double)x, (double)y, (double)z), CreatureType.fromName((String)type));
                    }
                    return;
                }
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        protected boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(Sign sign) {
            return new CreatureSpawner(this.getServer(), sign, this.risingEdge);
        }
    }
}

