/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class FlexibleSetBlock
extends AbstractIC {
    public FlexibleSetBlock(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Flexible Set";
    }

    public String getSignTitle() {
        return "FLEX SET";
    }

    public void trigger(ChipState chip) {
        String line3 = this.getSign().getLine(2).toUpperCase();
        String line4 = this.getSign().getLine(3);
        chip.setOutput(0, chip.getInput(0));
        if (line3.length() < 5) {
            return;
        }
        String axis = line3.substring(0, 1);
        if (!(axis.equals("X") || axis.equals("Y") || axis.equals("Z"))) {
            return;
        }
        String op = line3.substring(1, 2);
        if (!op.equals("+") && !op.equals("-")) {
            return;
        }
        String sdist = line3.substring(2, 3);
        int dist = -1;
        try {
            dist = Integer.parseInt(sdist);
        }
        catch (Exception e) {
            return;
        }
        if (op.equals("-")) {
            dist = -dist;
        }
        if (!line3.substring(3, 4).equals(":")) {
            return;
        }
        String sblock = line3.substring(4);
        int block = -1;
        try {
            block = Integer.parseInt(sblock);
        }
        catch (Exception e) {
            return;
        }
        boolean hold = line4.toUpperCase().contains("H");
        boolean inp = chip.getInput(0);
        Block body = SignUtil.getBackBlock(this.getSign().getBlock());
        int x = body.getX();
        int y = body.getY();
        int z = body.getZ();
        if (axis.equals("X")) {
            x += dist;
        } else if (axis.equals("Y")) {
            y += dist;
        } else {
            z += dist;
        }
        if (inp) {
            body.getWorld().getBlockAt(x, y, z).setTypeId(block);
        } else if (hold) {
            body.getWorld().getBlockAt(x, y, z).setTypeId(0);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new FlexibleSetBlock(this.getServer(), sign);
        }
    }
}

