/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class LightSensor
extends AbstractIC {
    protected boolean risingEdge;

    public LightSensor(Server server, Sign sign, boolean risingEdge) {
        super(server, sign);
        this.risingEdge = risingEdge;
    }

    public String getTitle() {
        return "Light Sensor";
    }

    public String getSignTitle() {
        return "LIGHT SENSOR";
    }

    public void trigger(ChipState chip) {
        if (this.risingEdge && chip.getInput(0) || !this.risingEdge && !chip.getInput(0)) {
            chip.setOutput(0, this.hasLight());
        }
    }

    private boolean hasLight() {
        int lightLevel = this.getSign().getWorld().getBlockAt(this.getSign().getBlock().getLocation().getBlockX(), this.getSign().getBlock().getLocation().getBlockY() + 1, this.getSign().getBlock().getLocation().getBlockZ()).getLightLevel();
        int specifiedLevel = 0;
        try {
            String specified = this.getSign().getLine(2);
            if (specified.length() > 0) {
                specifiedLevel = Integer.parseInt(specified);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return lightLevel >= specifiedLevel;
    }

    public static class Factory
    extends AbstractICFactory {
        protected boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(Sign sign) {
            return new LightSensor(this.getServer(), sign, this.risingEdge);
        }
    }
}

