/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class LightningSummon
extends AbstractIC {
    protected boolean risingEdge;

    public LightningSummon(Server server, Sign sign, boolean risingEdge) {
        super(server, sign);
        this.risingEdge = risingEdge;
    }

    public String getTitle() {
        return "Zeus Bolt";
    }

    public String getSignTitle() {
        return "ZEUS BOLT";
    }

    public void trigger(ChipState chip) {
        if (this.risingEdge && chip.getInput(0) || !this.risingEdge && !chip.getInput(0)) {
            Location loc = SignUtil.getBackBlock(this.getSign().getBlock()).getLocation();
            if (this.getSign().getLine(2).length() != 0) {
                try {
                    double y = (double)Integer.parseInt(this.getSign().getLine(2)) + loc.getY();
                    loc.setY(y);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            this.getSign().getWorld().strikeLightning(loc);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        protected boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(Sign sign) {
            return new LightningSummon(this.getServer(), sign, this.risingEdge);
        }
    }
}

