/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import org.bukkit.Server;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;

public class MessageSender
extends AbstractIC {
    protected boolean risingEdge;

    public MessageSender(Server server, Sign sign, boolean risingEdge) {
        super(server, sign);
        this.risingEdge = risingEdge;
    }

    public String getTitle() {
        return "Message Sender";
    }

    public String getSignTitle() {
        return "MESSAGE SENDER";
    }

    public void trigger(ChipState chip) {
        if (this.risingEdge && chip.getInput(0) || !this.risingEdge && !chip.getInput(0)) {
            chip.setOutput(0, this.sendMessage());
        }
    }

    private boolean sendMessage() {
        boolean sent = false;
        String name = this.getSign().getLine(2);
        String message = this.getSign().getLine(3);
        Player player = this.getServer().getPlayer(name);
        if (player != null) {
            player.sendMessage(message.replace("&", "\u00a7"));
            sent = true;
        }
        return sent;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        protected boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(Sign sign) {
            return new MessageSender(this.getServer(), sign, this.risingEdge);
        }
    }
}

