/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class WaterSensorST
extends AbstractIC
implements SelfTriggeredIC {
    public WaterSensorST(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Self-triggered Water Sensor";
    }

    public String getSignTitle() {
        return "ST WATER SENSOR";
    }

    public void think(ChipState chip) {
        chip.setOutput(0, this.hasWater());
    }

    private boolean hasWater() {
        Block b = SignUtil.getBackBlock(this.getSign().getBlock());
        int x = b.getX();
        int yOffset = b.getY();
        int z = b.getZ();
        try {
            String yOffsetLine = this.getSign().getLine(2);
            yOffset = yOffsetLine.length() > 0 ? (yOffset += Integer.parseInt(yOffsetLine)) : --yOffset;
        }
        catch (NumberFormatException e) {
            --yOffset;
        }
        int blockID = this.getSign().getBlock().getWorld().getBlockTypeIdAt(x, yOffset, z);
        return blockID == 8 || blockID == 9;
    }

    public boolean isActive() {
        return true;
    }

    public void trigger(ChipState chip) {
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new WaterSensorST(this.getServer(), sign);
        }
    }
}

