/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.gates.world.WirelessTransmitter;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class WirelessReceiver
extends AbstractIC {
    protected boolean risingEdge;
    protected String band;

    public WirelessReceiver(Server server, Sign sign, boolean risingEdge) {
        super(server, sign);
        this.risingEdge = risingEdge;
        this.band = sign.getLine(2);
    }

    public String getTitle() {
        return "Wireless Receiver";
    }

    public String getSignTitle() {
        return "RECEIVER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            Boolean val = WirelessTransmitter.getValue(this.band);
            if (val == null) {
                return;
            }
            chip.setOutput(0, val);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        protected boolean risingEdge;

        public Factory(Server server, boolean risingEdge) {
            super(server);
            this.risingEdge = risingEdge;
        }

        public IC create(Sign sign) {
            return new WirelessReceiver(this.getServer(), sign, this.risingEdge);
        }
    }
}

