/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFamily;
import com.sk89q.craftbook.ic.ICMechanicFactory;
import com.sk89q.craftbook.ic.PersistentIC;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICMechanic
extends PersistentMechanic {
    protected CircuitsPlugin plugin;
    protected String id;
    protected ICFamily family;
    protected IC ic;

    public ICMechanic(CircuitsPlugin plugin, String id, IC ic, ICFamily family, BlockWorldVector pos) {
        super(pos);
        this.plugin = plugin;
        this.id = id;
        this.ic = ic;
        this.family = family;
    }

    @Override
    public void onBlockRedstoneChange(final SourcedBlockRedstoneEvent event) {
        BlockWorldVector pt = this.getTriggerPositions().get(0);
        Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
        if (block.getTypeId() == 68) {
            final BlockState state = block.getState();
            Runnable runnable = new Runnable(){

                public void run() {
                    ChipState chipState = ICMechanic.this.family.detect(BukkitUtil.toWorldVector((Block)event.getSource()), (Sign)state);
                    ICMechanic.this.ic.trigger(chipState);
                }
            };
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, runnable, 2L);
        }
    }

    @Override
    public void unload() {
        this.ic.unload();
    }

    @Override
    public boolean isActive() {
        BlockState state;
        BlockWorldVector pt = this.getTriggerPositions().get(0);
        Block block = BukkitUtil.toWorld((WorldVector)pt).getBlockAt(BukkitUtil.toLocation((WorldVector)pt));
        if (block.getTypeId() == 68 && (state = block.getState()) instanceof Sign) {
            Sign sign = (Sign)state;
            Matcher matcher = ICMechanicFactory.codePattern.matcher(sign.getLine(1));
            if (!matcher.matches()) {
                return false;
            }
            if (!matcher.group(1).equalsIgnoreCase(this.id)) {
                return false;
            }
            if (this.ic instanceof PersistentIC) {
                return ((PersistentIC)this.ic).isActive();
            }
            return false;
        }
        return false;
    }

    @Override
    public List<BlockWorldVector> getWatchedPositions() {
        return new ArrayList<BlockWorldVector>();
    }
}

