/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.util.config.Configuration;

public class MechanismsConfiguration {
    public final File dataFolder;
    public final BookcaseSettings bookcaseSettings;
    public final BridgeSettings bridgeSettings;
    public final GateSettings gateSettings;
    public final ElevatorSettings elevatorSettings;
    public final CauldronSettings cauldronSettings;
    public final LightSwitchSettings lightSwitchSettings;

    public MechanismsConfiguration(Configuration cfg, File dataFolder) {
        this.dataFolder = dataFolder;
        this.bookcaseSettings = new BookcaseSettings(cfg);
        this.bridgeSettings = new BridgeSettings(cfg);
        this.gateSettings = new GateSettings(cfg);
        this.elevatorSettings = new ElevatorSettings(cfg);
        this.cauldronSettings = new CauldronSettings(cfg);
        this.lightSwitchSettings = new LightSwitchSettings(cfg);
    }

    public class LightSwitchSettings {
        public final boolean enable;

        private LightSwitchSettings(Configuration cfg) {
            this.enable = cfg.getBoolean("light-switch-enable", true);
        }
    }

    public class CauldronSettings {
        public final boolean enable;

        private CauldronSettings(Configuration cfg) {
            this.enable = cfg.getBoolean("cauldron-enable", true);
        }
    }

    public class ElevatorSettings {
        public final boolean enable;

        private ElevatorSettings(Configuration cfg) {
            this.enable = cfg.getBoolean("elevators-enable", true);
        }
    }

    public class GateSettings {
        public final boolean enable;
        public final boolean enableRedstone;

        private GateSettings(Configuration cfg) {
            this.enable = cfg.getBoolean("gate-enable", true);
            this.enableRedstone = cfg.getBoolean("gate-redstone", true);
        }
    }

    public class BridgeSettings {
        public final boolean enable;
        public final boolean enableRedstone;
        public final int maxLength;
        public final Set<Material> allowedBlocks;

        private BridgeSettings(Configuration cfg) {
            this.enable = cfg.getBoolean("bridge-enable", true);
            this.enableRedstone = cfg.getBoolean("bridge-redstone", true);
            this.maxLength = cfg.getInt("bridge-max-length", 30);
            List tids = cfg.getIntList("bridge-blocks", Arrays.asList(4, 5, 20, 43));
            HashSet<Material> allowedBlocks = new HashSet<Material>();
            for (Integer tid : tids) {
                allowedBlocks.add(Material.getMaterial((int)tid));
            }
            this.allowedBlocks = Collections.unmodifiableSet(allowedBlocks);
        }

        public boolean canUseBlock(Material b) {
            return this.allowedBlocks.contains(b);
        }
    }

    public class BookcaseSettings {
        public final boolean enable;
        public final String readLine;

        private BookcaseSettings(Configuration cfg) {
            this.enable = cfg.getBoolean("bookshelf-enable", true);
            this.readLine = cfg.getString("bookshelf-read-text", "You pick up a book...");
        }
    }
}

